/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableSet;
import pl.gov.mpips.zbc.Kody;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W27Validator
implements SimpleValidator<SwiadczenieSprawozdawcze> {
    private static final ImmutableSet<String> GRUPY = ImmutableSet.of((Object)"102", (Object)"112", (Object)"117", (Object)"130", (Object)"212", (Object)"213", (Object[])new String[]{"215", "216", "202", "203", "204", "205", "210", "211", "221", "318", "330", "416", "417", "430", "290"});
    private static final ImmutableSet<String> WYJATKI = ImmutableSet.of((Object)"202030", (Object)"202040", (Object)"202050", (Object)"202060", (Object)"202061", (Object)"318050", (Object[])new String[]{"290504"});

    @Override
    public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
        if (!this.uzupelnionaSytuacjaRodziny(target) && this.sytuacjaRodzinyJestWymagana(target)) {
            errors.rejectValue("sytuacjaRodziny", "W27", "Uzupe\u0142nienie sytuacji rodziny jest wymagane");
        }
    }

    private boolean uzupelnionaSytuacjaRodziny(SwiadczenieSprawozdawcze swiadczenie) {
        SytuacjaRodziny sytuacjaRodziny = swiadczenie.getSytuacjaRodziny();
        return sytuacjaRodziny != null;
    }

    private boolean sytuacjaRodzinyJestWymagana(SwiadczenieSprawozdawcze swiadczenie) {
        String kodSwiadczenia = swiadczenie.getKodSwiadczenia();
        if (kodSwiadczenia == null) {
            return false;
        }
        return Kody.prefiksy(kodSwiadczenia).anyMatch(arg_0 -> GRUPY.contains(arg_0)) && !WYJATKI.contains((Object)kodSwiadczenia);
    }
}

