<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"  version="1.0">
	<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" indent="no" method="html"/>
	<xsl:template match="/">
		<html id="html">
			<head>
				<title>Zbiór centralny</title>
				<style>
					body {
						background-color: #fff;
					}
					
					table {
						font-family: tahoma, verdana, helvetica, sans-serif;
						font-size: 12px;
						color: #003399;
						margin-top: 10 px;
						margin-right: 10 px;
						margin-bottom: 10 px;
						margin-left: 10 px;
						border-top-width: medium;
						border-right-width: medium;
						border-bottom-width: medium;
						border-left-width: medium;
						border-top-style: none;
						border-right-style: none;
						border-bottom-style: none;
						border-left-style: none;
						border-top-color: -moz-use-text-color;
						border-right-color: -moz-use-text-color;
						border-bottom-color: -moz-use-text-color;
						border-left-color: -moz-use-text-color;
						border-collapse: collapse;
					}
					
					th {
						background-color: #605b79;
						color: #fff;
						font-family: tahoma, verdana, helvetica, sans-serif;
						font-style: normal;
						font-variant: normal;
						font-weight: bold;
						font-size: 12px;
						line-height: normal;
						font-size-adjust: none;
						font-stretch: normal;
					}
					
					td {
						font-weight: normal;
						vertical-align: middle;
						text-align: center;
					}
					
					td.label {
						text-align: right;
						vertical-align: top;
						padding-right: 10px;
						padding-top: 5px;
					}
					
					td.right {
						text-align: right;
						padding-right: 10px;
					}
					
					td.left {
						text-align: left;
						padding-left: 4px;
					}
					
					fieldset {
						border-top-width: 1px;
						border-right-width: 1px;
						border-bottom-width: 1px;
						border-left-width: 1px;
						border-top-style: solid;
						border-right-style: solid;
						border-bottom-style: solid;
						border-left-style: solid;
						border-top-color: #605b79;
						border-right-color: #605b79;
						border-bottom-color: #605b79;
						border-left-color: #605b79;
						clear: left;
						font-weight: bold;
						font-size: 12px;
						color: #003399;
						background-color: #ffffff;
						background-image: none;
						background-repeat: repeat;
						background-attachment: scroll;
						background-x-position: 0%;
						background-y-position: 0%;
					}
					
					legend {
						background-color: #605b79;
						color: #fff;
						margin-left: 10px;
					}
					
					div#bodyDiv {
						width: 800px;
						margin-left: auto;
						margin-right: auto;
					}
					
					table.zawartoscZbioru td {
						text-align: center;
					}
					
					table.zawartoscZbioru td.left {
						text-align: left;
						padding-left: 4px;
					}
					
					table.zawartoscZbioru td.right {
						text-align: right;
						padding-right: 10px;
					}
					
					table.zawartoscZbioru th.left {
						text-align: left;
						padding-left: 8px;
					}
					
					table.zawartoscZbioru th.right {
						text-align: right;
						padding-right: 10px;
					}
				</style>
			</head>
			<body>
				<div id="bodyDiv">
					<xsl:call-template name="Zbiory"/>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="Zbiory">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny">
			<form name="zbiory">
				<fieldset>
					<legend>Dane zbioru centralnego</legend>
					<table style="width: 100%;">
						<tr>
							<td style="width: 25%;" class="label">Rok:</td>
							<td style="width: 25%;" class="left">
								<xsl:value-of select="Za_Okres/Rok"/>
							</td>
							<td style="width: 25%;" class="label">Kwartał:</td>
							<td style="width: 25%;" class="left">
								<xsl:value-of select="Za_Okres/Kwartal"/>
							</td>
						</tr>
						<tr>
							<td class="label">Nr wykonania:</td>
							<td class="left">
								<xsl:value-of select="Nr_Wykonania_Zbc"/>
							</td>
							<td class="label">Data utworzenia:</td>
							<td class="left">
								<xsl:value-of select="Data_Utworzenia"/>
							</td>
						</tr>
						<tr>
							<td class="label">Wersja WH:</td>
							<td class="left">
								<xsl:value-of select="/P_ZBRCEN/@Wersja_Wymagan"/>
							</td>
							<td class="label">Wersja formularza:</td>
							<td class="left">
								<xsl:value-of select="/P_ZBRCEN/@Wersja_Formularza"/>
							</td>
						</tr>
					</table>
				</fieldset>
				<br/>
				<fieldset>
					<legend>Dane jednostki utworzenia</legend>
					<table width="100%">
						<tr>
							<td style="width: 25%;" class="label">Keso:</td>
							<td style="width: 25%; vertical-align: top;" class="left">
								<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/@Kod_KESO"/>
							</td>
							<td style="width: 25%;" class="label">Nazwa:</td>
							<td style="width: 25%;" class="left">
								<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/Pelna_Nazwa"/>
							</td>
						</tr>
						<tr>
							<td class="label">Kod aplikacji:</td>
							<td class="left">
								<xsl:value-of select="/P_ZBRCEN/@Kod_Aplikacji"/>
							</td>
							<td class="label">Wersja aplikacji:</td>
							<td class="left">
								<xsl:value-of select="/P_ZBRCEN/@Wersja_Aplikacji"/>
							</td>
						</tr>
						<tr>
							<td class="label">Liczba rodzin w systemie:</td>
							<td class="left">
								<xsl:value-of select="Liczba_Rodzin_W_Systemie"/>
							</td>
							<td class="label">Liczba wywiadów:</td>
							<td class="left">
								<xsl:value-of select="Liczba_Utworzonych_Wywiadow"/>
							</td>
						</tr>
						<tr>
							<td class="label">Zestaw słowników nr:</td>
							<td class="left">
								<xsl:value-of select="Nr_Zestawu_Slownikow"/>
							</td>
							<td class="label">Liczba świadczeń:</td>
							<td class="left">
								<xsl:value-of select="count(Swiadczenia/Swiadczenie)"/>
							</td>
						</tr>
					</table>
				</fieldset>
				<br/>
				<fieldset>
					<legend>Zawartość</legend>
					<table border="px" style="width: 100%" class="zawartoscZbioru">
						<tr>
							<th style="width: 28%;">Informacja</th>
							<th style="width: 18%;">Kwartał 1</th>
							<th style="width: 18%;">Kwartał 2</th>
							<th style="width: 18%;">Kwartał 3</th>
							<th style="width: 18%;">Kwartał 4</th>
						</tr>
						<tr>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="'Wartość świadczeń POMOST'"/>
								<xsl:with-param name="class" select="'left'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw1"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw2"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw3"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw4"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="'Wartość świadczeń RB28-S'"/>
								<xsl:with-param name="class" select="'left'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw1"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw2"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw3"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw4"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="'Procent zgodności'"/>
								<xsl:with-param name="class" select="'left'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw1"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw2"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw3"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw4"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
						</tr>
					</table>
				</fieldset>
			</form>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="TableCell">
		<xsl:param name="value"/>
		<xsl:param name="class"/>
		<td>
			<xsl:attribute name="class">
				<xsl:value-of select="$class"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$value != ''">
					<xsl:value-of select="$value"/>
				</xsl:when>
				<xsl:otherwise>
					<br/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
</xsl:stylesheet>
