package pl.gov.mpips.zbc.v20090722;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W01ValidatorSR implements SimpleValidator<SytuacjaRodziny> {
	@Override
	public void validate(SytuacjaRodziny target, BasicErrors errors) {
		require(target, errors, "wielkosc",         SytuacjaRodziny::getWielkosc,         ImmutableSet.of("01", "02", "06", "07", "11", "13"));
		require(target, errors, "kodSkladuRodziny", SytuacjaRodziny::getKodSkladuRodziny, ImmutableSet.of("01", "02", "06", "07", "11", "13"));
		require(target, errors, "dochodNaOsobe",    SytuacjaRodziny::getDochodNaOsobe,    ImmutableSet.of("01", "02", "06", "07", "13"));
	}
	
	private void require(SytuacjaRodziny target, BasicErrors errors, String field, Function<SytuacjaRodziny, Object> getter, Set<String> codes) {
		String kod = target.getKodRodzajuOpisuSytuacji();
		if (codes.contains(kod)) {
			Object wartosc = getter.apply(target);
			if (isEmpty(wartosc)) {
				errors.rejectValue(field, "W01", opis(field) + " jest wymagane dla wybranego kodu rodzaju opisu sytuacji");
			}
		}
	}
	
	private boolean isEmpty(Object value) {
		if (value instanceof String) {
			return Strings.isNullOrEmpty((String) value);
		} else {
			return Objects.isNull(value);
		}
	}
	
	private String opis(String field) {
		switch (field) {
			case "wielkosc":         return "Określenie wielkości";
			case "kodSkladuRodziny": return "Uzupełnienie kodu składu rodziny";
			case "dochodNaOsobe":    return "Podanie dochodu na osobę";
		}
		throw new IllegalArgumentException();
	}
}
