package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W13Validator implements ComplexValidator<Problemy, SwiadczenieSprawozdawcze> {
	@Override
	public void validate(Problemy target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		List<String> kody = Listy.kody(target);
		for (int i = 0; i < kody.size(); i++) {
			if (kodProblemuWskazujeNaChorobe(kody.get(i)) && !sytuacjaWskazujeNaChorobe(context)) {
				errors.rejectValue("kod" + (i + 1), "W13", "Wskazano problem długotrwałej lub ciężkiej choroby mimo braku w składzie rodziny osób chorych lub przewlekle chorych");
			}
		}
	}
	
	private boolean sytuacjaWskazujeNaChorobe(SwiadczenieSprawozdawcze context) {
		List<CzlonekRodziny> czlonkowieRodziny = context.getCzlonkowieRodziny();
		return czlonkowieRodziny != null && czlonkowieRodziny.stream()
			.filter(Objects::nonNull)
			.map(CzlonekRodziny::getSytuacjaOsoby)
			.filter(Objects::nonNull)
			.map(SytuacjaOsoby::getKodStanuZdrowia)
			.filter(Objects::nonNull)
			.anyMatch(this::kodSytuacjiWskazujeNaChorobe);
	}
	
	private boolean kodSytuacjiWskazujeNaChorobe(String kod) {
		return Objects.equals(kod, "2")  // chory
			|| Objects.equals(kod, "3"); // przewlekle chory
	}
	
	private boolean kodProblemuWskazujeNaChorobe(String kod) {
		return Objects.equals(kod, "070"); // choroba
	}
}
