package pl.topteam.pomost.integracja.zbc.v20200306;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.threeten.extra.YearQuarter;

import pl.gov.mpips.zbc.v20200306.LiczbaPracownikowSocjalnych;
import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna;
import pl.gov.mpips.zbc.v20200306.SprawozdawczyWydatekSrodkow;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20200306.WartosciSwiadczen;
import pl.gov.mpips.zbc.v20200306.WartosciSwiadczen.POMOST;
import pl.gov.mpips.zbc.v20200306.WartosciSwiadczen.RB28S;
import pl.gov.mpips.zbc.v20200306.WniosekSprawozdawczy;
import pl.gov.mpips.zbc.v20200306.ZBRCEN;
import pl.gov.mpips.zbc.v20200306.ZbiorCentralny;
import pl.gov.mpips.zbc.v20200306.ZbiorCentralny.ProcentZgodnosci;

public class Kleik {
	public static ZBRCEN sklej(List<ZBRCEN> zbrceny) {
		ZBRCEN zbrcen = new ZBRCEN();
		Map<YearQuarter, List<ZbiorCentralny>> mapa = zgrupujPoOkresie(zbrceny);
		zbrcen.setZbioryCentralne(zbioryZaOkresy(mapa));
		return zbrcen;
	}

	private static Map<YearQuarter, List<ZbiorCentralny>> zgrupujPoOkresie(List<ZBRCEN> zbrceny) {
		Map<YearQuarter, List<ZbiorCentralny>> mapa = zbrceny.stream()
			.map(ZBRCEN::getZbioryCentralne)
			.flatMap(zc -> zc.stream())
			.collect(Collectors.groupingBy(ZbiorCentralny::getOkres));
		return mapa;
	}
	
	private static List<ZbiorCentralny> zbioryZaOkresy(Map<YearQuarter, List<ZbiorCentralny>> mapa) {
		List<ZbiorCentralny> zbioryZaOkresy = new ArrayList<>();
		mapa.forEach((okres, zbiory) -> {
			ZbiorCentralny sklejonyZbior = sklejZbiory(zbiory);
			sklejonyZbior.setDataUtworzenia(LocalDate.now());
			sklejonyZbior.setOkres(okres);
			zbioryZaOkresy.add(sklejonyZbior);
		});
		return zbioryZaOkresy;
	}
	
	private static ZbiorCentralny sklejZbiory(List<ZbiorCentralny> zbiory) {
		return zbiory.stream().reduce(Kleik::zbior).get();
	}

	private static ZbiorCentralny zbior(ZbiorCentralny zbior1, ZbiorCentralny zbior2) {
		ZbiorCentralny zbior = new ZbiorCentralny();
		zbior.setLiczbaRodzinWSystemie(zbior1.getLiczbaRodzinWSystemie().add(zbior2.getLiczbaRodzinWSystemie()));
		zbior.setLiczbaUtworzonychWywiadow(zbior1.getLiczbaUtworzonychWywiadow().add(zbior2.getLiczbaUtworzonychWywiadow()));
		zbior.setLiczbaPracownikowSocjalnych(liczbaPracownikowSocjalnych(zbior1.getLiczbaPracownikowSocjalnych(), zbior2.getLiczbaPracownikowSocjalnych()));
		zbior.setWartoscSwiadczen(wartoscSwiadczen(zbior1.getWartoscSwiadczen(), zbior2.getWartoscSwiadczen()));
		zbior.setSwiadczenia(swiadczenia(zbior1.getSwiadczenia(), zbior2.getSwiadczenia()));
		zbior.setWydatkiSrodkow(wydatkiSrodkow(zbior1.getWydatkiSrodkow(), zbior2.getWydatkiSrodkow()));
		zbior.setDecyzjeOdmowne(decyzjeOdmowne(zbior1.getDecyzjeOdmowne(), zbior2.getDecyzjeOdmowne()));
		zbior.setWnioski(wnioski(zbior1.getWnioski(), zbior2.getWnioski()));
		zbior.setSytuacjeRodzin(sytuacjeRodzin(zbior1.getSytuacjeRodzin(), zbior2.getSytuacjeRodzin()));
		zbior.setSytuacjeOsob(sytuacjeOsob(zbior1.getSytuacjeOsob(), zbior2.getSytuacjeOsob()));
		zbior.setProcentZgodnosci(procentZgodnosci(zbior.getWartoscSwiadczen()));
		return zbior;
	}

	private static LiczbaPracownikowSocjalnych liczbaPracownikowSocjalnych(LiczbaPracownikowSocjalnych liczbaPracownikow1, LiczbaPracownikowSocjalnych liczbaPracownikow2) {
		LiczbaPracownikowSocjalnych liczbaPracownikow = new LiczbaPracownikowSocjalnych();
		liczbaPracownikow.setWyksztalcenieWyzsze(liczbaPracownikow1.getWyksztalcenieWyzsze().add(liczbaPracownikow2.getWyksztalcenieWyzsze()));
		liczbaPracownikow.setWyksztalcenieSrednie(liczbaPracownikow1.getWyksztalcenieSrednie().add(liczbaPracownikow2.getWyksztalcenieSrednie()));
		liczbaPracownikow.setWyksztalceniePozostale(liczbaPracownikow1.getWyksztalceniePozostale().add(liczbaPracownikow2.getWyksztalceniePozostale()));
		liczbaPracownikow.setWyksztalcenieBrakDanych(liczbaPracownikow1.getWyksztalcenieBrakDanych().add(liczbaPracownikow2.getWyksztalcenieBrakDanych()));
		return liczbaPracownikow;
	}
	
	private static WartosciSwiadczen wartoscSwiadczen(WartosciSwiadczen wartosciSwiadczen1, WartosciSwiadczen wartosciSwiadczen2) {
		WartosciSwiadczen wartosciSwiadczen = new WartosciSwiadczen();
		wartosciSwiadczen.setPOMOST(pomost(wartosciSwiadczen1.getPOMOST(), wartosciSwiadczen2.getPOMOST()));
		wartosciSwiadczen.setRB28S(rb28s(wartosciSwiadczen1.getRB28S(), wartosciSwiadczen2.getRB28S()));
		return wartosciSwiadczen;
	}

	private static POMOST pomost(POMOST pomost1, POMOST pomost2) {
		POMOST pomost = new POMOST();
		pomost.setKwartal1(pomost1.getKwartal1().add(pomost2.getKwartal1()));
		pomost.setKwartal2(pomost1.getKwartal2().add(pomost2.getKwartal2()));
		pomost.setKwartal3(pomost1.getKwartal3().add(pomost2.getKwartal3()));
		pomost.setKwartal4(pomost1.getKwartal4().add(pomost2.getKwartal4()));
		return pomost;
	}
	
	private static RB28S rb28s(RB28S rb28s1, RB28S rb28s2) {
		RB28S rb28s = new RB28S();
		rb28s.setKwartal1(rb28s1.getKwartal1().add(rb28s2.getKwartal1()));
		rb28s.setKwartal2(rb28s1.getKwartal2().add(rb28s2.getKwartal2()));
		rb28s.setKwartal3(rb28s1.getKwartal3().add(rb28s2.getKwartal3()));
		rb28s.setKwartal4(rb28s1.getKwartal4().add(rb28s2.getKwartal4()));
		return rb28s;
	}
	
	private static ProcentZgodnosci procentZgodnosci(WartosciSwiadczen wartosciSwiadczen) {
		POMOST pomost = wartosciSwiadczen.getPOMOST();
		BigDecimal pomost1 = pomost.getKwartal1().subtract(BigDecimal.ZERO);
		BigDecimal pomost2 = pomost.getKwartal2().subtract(pomost.getKwartal1());
		BigDecimal pomost3 = pomost.getKwartal3().subtract(pomost.getKwartal2());
		BigDecimal pomost4 = pomost.getKwartal4().subtract(pomost.getKwartal3());
		RB28S rb28s = wartosciSwiadczen.getRB28S();
		BigDecimal rb28s1 = rb28s.getKwartal1().subtract(BigDecimal.ZERO);
		BigDecimal rb28s2 = rb28s.getKwartal2().subtract(rb28s.getKwartal1());
		BigDecimal rb28s3 = rb28s.getKwartal3().subtract(rb28s.getKwartal2());
		BigDecimal rb28s4 = rb28s.getKwartal4().subtract(rb28s.getKwartal3());
		ProcentZgodnosci procentZgodnosci = new ProcentZgodnosci();
		procentZgodnosci.setKwartal1(procentZgodnosci(pomost1, rb28s1));
		procentZgodnosci.setKwartal2(procentZgodnosci(pomost2, rb28s2));
		procentZgodnosci.setKwartal3(procentZgodnosci(pomost3, rb28s3));
		procentZgodnosci.setKwartal4(procentZgodnosci(pomost4, rb28s4));
		return procentZgodnosci;
	}
	
	private static BigInteger procentZgodnosci(BigDecimal pomost, BigDecimal rb28s) {
		return pomost.signum() > 0 && rb28s.signum() > 0 ? pomost.movePointRight(2).divideToIntegralValue(rb28s).toBigIntegerExact() : BigInteger.ZERO;
	}
	
	private static List<SwiadczenieSprawozdawcze> swiadczenia(List<SwiadczenieSprawozdawcze> swiadczenia1, List<SwiadczenieSprawozdawcze> swiadczenia2) {
		int id = 1;
		List<SwiadczenieSprawozdawcze> swiadczenia = sklej(swiadczenia1, swiadczenia2);
		for (SwiadczenieSprawozdawcze swiadczenie : swiadczenia) {
			swiadczenie.setNumer(String.valueOf(id));
			id++;
		}
		return swiadczenia;
	}
	
	private static List<SprawozdawczyWydatekSrodkow> wydatkiSrodkow(List<SprawozdawczyWydatekSrodkow> wydatkiSrodkow1, List<SprawozdawczyWydatekSrodkow> wydatkiSrodkow2) {
		int id = 1;
		List<SprawozdawczyWydatekSrodkow> wydatkiSrodkow = sklej(wydatkiSrodkow1, wydatkiSrodkow2);
		for (SprawozdawczyWydatekSrodkow wydatekSrodkow : wydatkiSrodkow) {
			wydatekSrodkow.setNumer(String.valueOf(id));
			id++;
		}
		return wydatkiSrodkow;
	}
	
	private static List<SprawozdawczaDecyzjaOdmowna> decyzjeOdmowne(List<SprawozdawczaDecyzjaOdmowna> decyzjeOdmowne1, List<SprawozdawczaDecyzjaOdmowna> decyzjeOdmowne2) {
		int id = 1;
		List<SprawozdawczaDecyzjaOdmowna> decyzjeOdmowne = sklej(decyzjeOdmowne1, decyzjeOdmowne2);
		for (SprawozdawczaDecyzjaOdmowna decyzjaOdmowna : decyzjeOdmowne) {
			decyzjaOdmowna.setNumer(String.valueOf(id));
			id++;
		}
		return decyzjeOdmowne;
	}
	
	private static List<WniosekSprawozdawczy> wnioski(List<WniosekSprawozdawczy> wnioski1, List<WniosekSprawozdawczy> wnioski2) {
		int id = 1;
		List<WniosekSprawozdawczy> wnioski = sklej(wnioski1, wnioski2);
		for (WniosekSprawozdawczy wniosek : wnioski) {
			wniosek.setNumer(String.valueOf(id));
			id++;
		}
		return wnioski;
	}
	
	private static List<SytuacjaRodziny> sytuacjeRodzin(List<SytuacjaRodziny> sytuacjeRodzin1, List<SytuacjaRodziny> sytuacjeRodzin2) {
		int id = 1;
		List<SytuacjaRodziny> sytuacjeRodzin = sklej(sytuacjeRodzin1, sytuacjeRodzin2);
		for (SytuacjaRodziny sytuacjaRodziny : sytuacjeRodzin) {
			sytuacjaRodziny.setIdSytuacjiRodziny(String.valueOf(id));
			id++;
		}
		return sytuacjeRodzin;
	}
	
	private static List<SytuacjaOsoby> sytuacjeOsob(List<SytuacjaOsoby> sytuacjeOsob1, List<SytuacjaOsoby> sytuacjeOsob2) {
		int id = 1;
		List<SytuacjaOsoby> sytuacjeOsob = sklej(sytuacjeOsob1, sytuacjeOsob2);
		for (SytuacjaOsoby sytuacjaOsoby : sytuacjeOsob) {
			sytuacjaOsoby.setIdSytuacjiOsoby(String.valueOf(id));
			id++;
		}
		return sytuacjeOsob;
	}
	
	private static<T> List<T> sklej(List<T> lista1, List<T> lista2) {
		List<T> lista = new ArrayList<>();
		if (lista1 != null) {
			lista.addAll(lista1);
		}
		if (lista2 != null) {
			lista.addAll(lista2);
		}
		return lista;
	}
}

