/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import pl.gov.mpips.zbc.v20090722.SprawozdawczaDecyzjaOdmowna;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20090722.WniosekSprawozdawczy;
import pl.gov.mpips.zbc.v20090722.ZbiorCentralny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W37Validator
implements SimpleValidator<ZbiorCentralny> {
    @Override
    public void validate(ZbiorCentralny target, BasicErrors errors) {
        SytuacjaRodziny sytuacjaRodziny;
        SetMultimap<SytuacjaRodziny, String> idRodzin = this.idRodzin(target);
        if (target.getSwiadczenia() != null) {
            for (int s = 0; s < target.getSwiadczenia().size(); ++s) {
                SwiadczenieSprawozdawcze swiadczenie = target.getSwiadczenia().get(s);
                sytuacjaRodziny = swiadczenie.getSytuacjaRodziny();
                if (idRodzin.get((Object)sytuacjaRodziny).size() <= 1) continue;
                errors.rejectValue("swiadczenia[" + s + "].idRodziny", "W37", "Istniej\u0105 \u015bwiadczenia, decyzje odmowne lub wnioski wskazuj\u0105ce na ten sam opis sytuacji rodziny, lecz inn\u0105 rodzin\u0119");
            }
        }
        if (target.getDecyzjeOdmowne() != null) {
            for (int d = 0; d < target.getDecyzjeOdmowne().size(); ++d) {
                SprawozdawczaDecyzjaOdmowna decyzjaOdmowna = target.getDecyzjeOdmowne().get(d);
                sytuacjaRodziny = decyzjaOdmowna.getSytuacjaRodziny();
                if (idRodzin.get((Object)sytuacjaRodziny).size() <= 1) continue;
                errors.rejectValue("decyzjeOdmowne[" + d + "].idRodziny", "W37", "Istniej\u0105 \u015bwiadczenia, decyzje odmowne lub wnioski wskazuj\u0105ce na ten sam opis sytuacji rodziny, lecz inn\u0105 rodzin\u0119");
            }
        }
        if (target.getWnioski() != null) {
            for (int w = 0; w < target.getWnioski().size(); ++w) {
                WniosekSprawozdawczy wniosek = target.getWnioski().get(w);
                sytuacjaRodziny = wniosek.getSytuacjaRodziny();
                if (idRodzin.get((Object)sytuacjaRodziny).size() <= 1) continue;
                errors.rejectValue("wnioski[" + w + "].idRodziny", "W37", "Istniej\u0105 \u015bwiadczenia, decyzje odmowne lub wnioski wskazuj\u0105ce na ten sam opis sytuacji rodziny, lecz inn\u0105 rodzin\u0119");
            }
        }
    }

    private SetMultimap<SytuacjaRodziny, String> idRodzin(ZbiorCentralny target) {
        ImmutableSetMultimap.Builder indeks = ImmutableSetMultimap.builder();
        if (target.getSwiadczenia() != null) {
            for (SwiadczenieSprawozdawcze swiadczenieSprawozdawcze : target.getSwiadczenia()) {
                if (swiadczenieSprawozdawcze.getSytuacjaRodziny() == null || swiadczenieSprawozdawcze.getIdRodziny() == null) continue;
                indeks.put((Object)swiadczenieSprawozdawcze.getSytuacjaRodziny(), (Object)swiadczenieSprawozdawcze.getIdRodziny());
            }
        }
        if (target.getDecyzjeOdmowne() != null) {
            for (SprawozdawczaDecyzjaOdmowna decyzjaOdmowna : target.getDecyzjeOdmowne()) {
                if (decyzjaOdmowna.getSytuacjaRodziny() == null || decyzjaOdmowna.getIdRodziny() == null) continue;
                indeks.put((Object)decyzjaOdmowna.getSytuacjaRodziny(), (Object)decyzjaOdmowna.getIdRodziny());
            }
        }
        if (target.getWnioski() != null) {
            for (WniosekSprawozdawczy wniosekSprawozdawczy : target.getWnioski()) {
                if (wniosekSprawozdawczy.getSytuacjaRodziny() == null || wniosekSprawozdawczy.getIdRodziny() == null) continue;
                indeks.put((Object)wniosekSprawozdawczy.getSytuacjaRodziny(), (Object)wniosekSprawozdawczy.getIdRodziny());
            }
        }
        return indeks.build();
    }
}

