/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20200306.ZbiorCentralny;

public class ZbiorCentralnyListener {
    private final ZbiorCentralny zbiorCentralny;

    public ZbiorCentralnyListener(ZbiorCentralny zbiorCentralny) {
        this.zbiorCentralny = (ZbiorCentralny)Preconditions.checkNotNull((Object)zbiorCentralny);
    }

    void beforeMarshal(Marshaller marshaller) {
        if (this.zbiorCentralny.getSwiadczenia() != null && this.zbiorCentralny.getSwiadczenia().isEmpty()) {
            this.zbiorCentralny.setSwiadczenia(null);
        }
        if (this.zbiorCentralny.getWydatkiSrodkow() != null && this.zbiorCentralny.getWydatkiSrodkow().isEmpty()) {
            this.zbiorCentralny.setWydatkiSrodkow(null);
        }
        if (this.zbiorCentralny.getDecyzjeOdmowne() != null && this.zbiorCentralny.getDecyzjeOdmowne().isEmpty()) {
            this.zbiorCentralny.setDecyzjeOdmowne(null);
        }
        if (this.zbiorCentralny.getWnioski() != null && this.zbiorCentralny.getWnioski().isEmpty()) {
            this.zbiorCentralny.setWnioski(null);
        }
        if (this.zbiorCentralny.getSytuacjeRodzin() != null && this.zbiorCentralny.getSytuacjeRodzin().isEmpty()) {
            this.zbiorCentralny.setSytuacjeRodzin(null);
        }
        if (this.zbiorCentralny.getSytuacjeOsob() != null && this.zbiorCentralny.getSytuacjeOsob().isEmpty()) {
            this.zbiorCentralny.setSytuacjeOsob(null);
        }
    }

    void afterMarshal(Marshaller marshaller) {
    }

    void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) {
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        ImmutableMap<String, SytuacjaOsoby> sytuacjeOsob = ZbiorCentralnyListener.sytuacjeOsob(this.zbiorCentralny);
        ImmutableMap<String, SytuacjaRodziny> sytuacjeRodzin = ZbiorCentralnyListener.sytuacjeRodzin(this.zbiorCentralny);
        if (this.zbiorCentralny.getDecyzjeOdmowne() != null) {
            this.zbiorCentralny.getDecyzjeOdmowne().forEach(decyzjaOdmowna -> {
                decyzjaOdmowna.setSytuacjaOsoby(ZbiorCentralnyListener.zamiennik(decyzjaOdmowna.getSytuacjaOsoby(), sytuacjeOsob));
                decyzjaOdmowna.setSytuacjaRodziny(ZbiorCentralnyListener.zamiennik(decyzjaOdmowna.getSytuacjaRodziny(), sytuacjeRodzin));
            });
        }
        if (this.zbiorCentralny.getSwiadczenia() != null) {
            this.zbiorCentralny.getSwiadczenia().forEach(swiadczenie -> {
                swiadczenie.setSytuacjaRodziny(ZbiorCentralnyListener.zamiennik(swiadczenie.getSytuacjaRodziny(), sytuacjeRodzin));
                if (swiadczenie.getCzlonkowieRodziny() != null) {
                    swiadczenie.getCzlonkowieRodziny().forEach(czlonekRodziny -> czlonekRodziny.setSytuacjaOsoby(ZbiorCentralnyListener.zamiennik(czlonekRodziny.getSytuacjaOsoby(), sytuacjeOsob)));
                }
            });
        }
        if (this.zbiorCentralny.getWnioski() != null) {
            this.zbiorCentralny.getWnioski().forEach(wniosek -> {
                wniosek.setSytuacjaOsoby(ZbiorCentralnyListener.zamiennik(wniosek.getSytuacjaOsoby(), sytuacjeOsob));
                wniosek.setSytuacjaRodziny(ZbiorCentralnyListener.zamiennik(wniosek.getSytuacjaRodziny(), sytuacjeRodzin));
            });
        }
    }

    private static ImmutableMap<String, SytuacjaOsoby> sytuacjeOsob(ZbiorCentralny zbiorCentralny) {
        List sytuacjeOsob = (List)MoreObjects.firstNonNull(zbiorCentralny.getSytuacjeOsob(), (Object)ImmutableList.of());
        return Maps.uniqueIndex((Iterable)sytuacjeOsob, SytuacjaOsoby::getIdSytuacjiOsoby);
    }

    private static ImmutableMap<String, SytuacjaRodziny> sytuacjeRodzin(ZbiorCentralny zbiorCentralny) {
        List sytuacjeRodzin = (List)MoreObjects.firstNonNull(zbiorCentralny.getSytuacjeRodzin(), (Object)ImmutableList.of());
        return Maps.uniqueIndex((Iterable)sytuacjeRodzin, SytuacjaRodziny::getIdSytuacjiRodziny);
    }

    private static SytuacjaOsoby zamiennik(SytuacjaOsoby namiastka, Map<String, SytuacjaOsoby> indeks) {
        return namiastka == null ? null : indeks.get(namiastka.getIdSytuacjiOsoby());
    }

    private static SytuacjaRodziny zamiennik(SytuacjaRodziny namiastka, Map<String, SytuacjaRodziny> indeks) {
        return namiastka == null ? null : indeks.get(namiastka.getIdSytuacjiRodziny());
    }
}

