/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W12Validator
implements ComplexValidator<SwiadczenieSprawozdawcze.Problemy, SwiadczenieSprawozdawcze> {
    private static final ImmutableSet<String> DOPUSZCZALNY_BRAK_OSOB_NIEPELNOSPRAWNYCH_W_SKLADZIE = ImmutableSet.of((Object)"18");

    @Override
    public void validate(SwiadczenieSprawozdawcze.Problemy target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
        if (this.dopuszczalnyBrakOsobNiepelnosprawnychWSkladzie(context)) {
            return;
        }
        List<String> kody = Listy.kody(target);
        for (int i = 0; i < kody.size(); ++i) {
            if (!this.wskazanoNiepelnosprawnosc(kody.get(i)) || !this.brakOsobNiepelnosprawnychWSkladzie(context)) continue;
            errors.rejectValue("kod" + (i + 1), "W12", "Wskazano problem niepe\u0142nosprawno\u015bci mimo braku w sk\u0142adzie rodziny os\u00f3b niepe\u0142nosprawnych");
        }
    }

    private boolean wskazanoNiepelnosprawnosc(String kod) {
        return Objects.equals(kod, "060");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean brakOsobNiepelnosprawnychWSkladzie(SwiadczenieSprawozdawcze context) {
        List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = context.getCzlonkowieRodziny();
        if (czlonkowieRodziny == null) return false;
        if (!czlonkowieRodziny.stream().filter(Objects::nonNull).map(SwiadczenieSprawozdawcze.CzlonekRodziny::getSytuacjaOsoby).filter(Objects::nonNull).map(SytuacjaOsoby::getCzyNiepelnosprawny).filter(Objects::nonNull).noneMatch(Boolean.TRUE::equals)) return false;
        return true;
    }

    private boolean dopuszczalnyBrakOsobNiepelnosprawnychWSkladzie(SwiadczenieSprawozdawcze context) {
        SytuacjaRodziny sytuacjaRodziny = context.getSytuacjaRodziny();
        if (sytuacjaRodziny == null) {
            return false;
        }
        String kodRodzajuOpisuSytuacji = sytuacjaRodziny.getKodRodzajuOpisuSytuacji();
        if (kodRodzajuOpisuSytuacji == null) {
            return false;
        }
        return DOPUSZCZALNY_BRAK_OSOB_NIEPELNOSPRAWNYCH_W_SKLADZIE.contains((Object)kodRodzajuOpisuSytuacji);
    }
}

