/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.List;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W18Validator
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    private static final ImmutableSet<String> ZRODLA_ZAROBKOWE = ImmutableSet.of((Object)"01", (Object)"02", (Object)"03", (Object)"04", (Object)"06", (Object)"07", (Object[])new String[]{"10", "11", "12", "13", "14", "17", "18"});

    @Override
    public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
        SytuacjaOsoby.Dochody dochody = target.getDochody();
        if (dochody == null) {
            return;
        }
        List<String> zrodla = Listy.zrodla(dochody);
        for (int z = 0; z < 4; ++z) {
            if (!this.wymagaPracy(zrodla.get(z)) || !this.zbytMlodyZebyPracowac(target, context)) continue;
            errors.rejectValue("dochody.zrodlo" + (z + 1), "W18", "Wybrane \u017ar\u00f3d\u0142o dochodu jest niedozwolone dla os\u00f3b m\u0142odszych ni\u017c 15 lat");
        }
    }

    private boolean zbytMlodyZebyPracowac(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny kontekst) {
        LocalDate dataOpisuSytuacji = kontekst.getDataOpisuSytuacji();
        LocalDate dataUrodzenia = sytuacjaOsoby.getDataUrodzenia();
        return dataOpisuSytuacji != null && dataUrodzenia != null && ExtraChronoUnit.LEGAL_YEARS.between((Temporal)dataUrodzenia, (Temporal)dataOpisuSytuacji) < 15L;
    }

    private boolean wymagaPracy(String zrodlo) {
        return ZRODLA_ZAROBKOWE.contains((Object)zrodlo);
    }
}

