package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;

import com.google.common.base.Objects;

import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W16Validator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	@Override
	public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
		if (zaWczesnieNaNauke(sytuacjaOsoby, context) && !brakWyksztalcenia(sytuacjaOsoby)) {
			errors.rejectValue("kodRodzajuWyksztalcenia", "W16", "U osób młodszych niż 5 lat należy wskazać brak wykształcenia");
		}
	}
	
	private boolean zaWczesnieNaNauke(SytuacjaOsoby target, SytuacjaRodziny context) {
		LocalDate dataUrodzenia = target.getDataUrodzenia();
		if (dataUrodzenia == null) return false;
		LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return false;
		//
		return ExtraChronoUnit.LEGAL_YEARS.between(dataUrodzenia, dataOpisuSytuacji) < 5;
	}
	
	private boolean brakWyksztalcenia(SytuacjaOsoby sytuacjaOsoby) {
		String kodRodzajuWyksztalcenia = sytuacjaOsoby.getKodRodzajuWyksztalcenia();
		return Objects.equal(kodRodzajuWyksztalcenia, "70");
	}
}
