package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;

import org.threeten.extra.YearQuarter;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.Kody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W20Validator implements ComplexValidator<SwiadczenieSprawozdawcze, ZbiorCentralny> {
	private static final ImmutableSet<String> WYLACZONE = ImmutableSet.of(
		"111000", "140", "206000", "207", "208", "209x", "214", "214x", "214y", "217000", "320", "408", "409x"
	);
	
	@Override
	public void validate(SwiadczenieSprawozdawcze target, ZbiorCentralny context, BasicErrors errors) {
		SytuacjaRodziny sytuacjaRodziny = target.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return;
		LocalDate dataOpisuSytuacji = sytuacjaRodziny.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return;
		YearQuarter okresSprawozdawczy = context.getOkres();
		if (okresSprawozdawczy == null) return;
		String kodSwiadczenia = target.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		if (Kody.prefiksy(kodSwiadczenia).anyMatch(WYLACZONE::contains)) return;
		//
		if (dataOpisuSytuacji.isAfter(okresSprawozdawczy.atEndOfQuarter())) {
			errors.rejectValue("sytuacjaRodziny.dataOpisuSytuacji", "W20", "Data opisu sytuacji nie może być późniejsza niż ostatni dzień kwartału za który przesyłamy dane w zbiorze centralnym");
		}
	}
}
