package pl.gov.mpips.zbc.v20200306;

import java.util.Objects;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby.Dochody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W03aValidator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	private static final ImmutableSet<String> DOCHODY_WYMAGANE = ImmutableSet.of("01", "02", "06", "11", "13");
	
	@Override
	public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
		String kodRodzajuOpisuSytuacji = context.getKodRodzajuOpisuSytuacji();
		if (DOCHODY_WYMAGANE.contains(kodRodzajuOpisuSytuacji)) {
			Dochody dochody = sytuacjaOsoby.getDochody();
			if (dochody == null) return;
			if (Strings.isNullOrEmpty(dochody.getZrodlo1())) {
				errors.rejectValue("dochody.zrodlo1", "W03a", "Podanie kodu źródła dochodu jest wymagane ze względu na kod rodzaju opisu sytuacji rodziny");
			}
			if (Objects.isNull(dochody.getKwotaMiesiecznie1())) {
				errors.rejectValue("dochody.kwotaMiesiecznie1", "W03a", "Podanie kwoty dochodu jest wymagane ze względu na kod rodzaju opisu sytuacji rodziny");
			}
		}
	}
}
