package pl.gov.mpips.zbc.v20200306;

import java.util.Objects;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W08Validator implements SimpleValidator<SytuacjaOsoby> {
	@Override
	public void validate(SytuacjaOsoby target, BasicErrors errors) {
		String kodRoliWRodzinie = target.getKodRoliWRodzinie();
		String kodPokrewienstwaZGlowaRodziny = target.getKodPokrewienstwaZGlowaRodziny();
		if (kodRoliWRodzinie == null || kodPokrewienstwaZGlowaRodziny == null) return;
		if (Objects.equals(kodRoliWRodzinie, "1") && !Objects.equals(kodPokrewienstwaZGlowaRodziny, "98")) {
			errors.rejectValue("kodPokrewienstwaZGlowaRodziny", "W08", "Niezgodne wartości kodu pokrewienstwa z głową rodziny i kodu roli w rodzinie");
		}
		if (Objects.equals(kodRoliWRodzinie, "2") && Objects.equals(kodPokrewienstwaZGlowaRodziny, "98")) {
			errors.rejectValue("kodPokrewienstwaZGlowaRodziny", "W08", "Niezgodne wartości kodu pokrewienstwa z głową rodziny i kodu roli w rodzinie");
		}
	}
}
