package pl.gov.mpips.zbc.v20200306;

import com.google.common.base.Strings;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W30Validator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final String POMOC_DLA_RODZIN_ZASTEPCZYCH = "417";
	
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		String kodSwiadczenia = target.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		//
		if (kodSwiadczenia.startsWith(POMOC_DLA_RODZIN_ZASTEPCZYCH)) {
			String kodRodzajuRodzinyZastepczej = target.getKodRodzajuRodzinyZastepczej();
			if (Strings.isNullOrEmpty(kodRodzajuRodzinyZastepczej)) {
				errors.rejectValue("kodRodzajuRodzinyZastepczej", "W30", "Określenie rodzaju rodziny zastępczej jest wymagane ze względu na kod świadczenia");
			}
		}
	}
}
