<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"  version="1.0">
	<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" indent="no" method="html"/>
	<xsl:param name="context" select="'Zbiory'"/>
	<xsl:param name="contextParamNrSpraw"/>
	<xsl:param name="contextParamIdOsoby"/>
	<xsl:param name="contextParamKodZrFin"/>
	<xsl:param name="page" select="1"/>
	<xsl:param name="pageSize" select="20"/>
	<xsl:param name="firstRow" select="($page - 1) *  $pageSize + 1"/>
	<xsl:param name="lastRow" select="$page * $pageSize"/>
	<xsl:param name="filterColumn"/>
	<xsl:param name="filterPattern"/>
	<xsl:param name="transformationDest" select="''"/>

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="$transformationDest = ''">
				<html id="html">
					<head>
						<title>Zbiór centralny</title>
						<style>
							body {
								background-color: #e8f5fe;
							}
							
							table {
								font-family: tahoma, verdana, helvetica, sans-serif;
								font-size: 12px;
								color: #003399;
								margin-top: 10 px;
								margin-right: 10 px;
								margin-bottom: 10 px;
								margin-left: 10 px;
								border-top-width: medium;
								border-right-width: medium;
								border-bottom-width: medium;
								border-left-width: medium;
								border-top-style: none;
								border-right-style: none;
								border-bottom-style: none;
								border-left-style: none;
								border-top-color: -moz-use-text-color;
								border-right-color: -moz-use-text-color;
								border-bottom-color: -moz-use-text-color;
								border-left-color: -moz-use-text-color;;
								color: #003399;
							}
							
							th {
								background-color: #99ccff;
								font-family: tahoma, verdana, helvetica, sans-serif;
								font-style: normal;
								font-variant: normal;
								font-weight: bold;
								font-size: 12px;
								line-height: normal;
								font-size-adjust: none;
								font-stretch: normal;
							}
							
							td {
								font-weight: normal;
								vertical-align: middle;
								text-align: center;
							}
							
							td.label {
								text-align: right;
								vertical-align: top;
								padding-right: 10px;
								padding-top: 5px;
							}
							
							td.right {
								text-align: right;
								padding-right: 10px;
							}
							
							td.left {
								text-align: left;
								padding-left: 4px;
							}
							
							fieldset {
								border-top-width: 1px;
								border-right-width: 1px;
								border-bottom-width: 1px;
								border-left-width: 1px;
								border-top-style: solid;
								border-right-style: solid;
								border-bottom-style: solid;
								border-left-style: solid;
								border-top-color: #99ccff;
								border-right-color: #99ccff;
								border-bottom-color: #99ccff;
								border-left-color: #99ccff;
								clear: left;
								font-weight: bold;
								font-size: 12px;
								color: #003399;
								background-color: #b8dcff;
								background-image: none;
								background-repeat: repeat;
								background-attachment: scroll;
								background-x-position: 0%;
								background-y-position: 0%;
							}
							
							legend {
								background-color: #99ccff;
								margin-left: 10px;
							}
							
							.disabled {
								font-family: tahoma, verdana, helvetica, sans-serif;
								font-size: 12px; width : 200px;
								background-color: #dddddd;
								width: 200px;
							}
							
							div.tableHeader {
								width: 100%;
							}
							
							div.tableHeader table {
								margin-left: auto;
								margin-right: auto;
							}
							
							div.tableFilter {
								width: 100%;
							}
							
							div.tableFilter table {
								margin-left: auto;
								margin-right: 0px;
							}
							
							div#bodyDiv {
								width: 800px;
								margin-left: auto;
								margin-right: auto;
							}
							
							input.short {
								font-family: tahoma, verdana, helvetica, sans-serif;
								font-size: 12px;
								background-color: #dddddd;
								width: 100px;
							}
							
							input.medium {
								font-family: tahoma, verdana, helvetica, sans-serif;
								font-size: 12px;
								background-color: #dddddd;
								width: 200px;
							}
							
							input.long {
								font-family: tahoma, verdana, helvetica, sans-serif;
								font-size: 12px;
								background-color: #dddddd;
								width: 400px;
							}
							
							table.zawartoscZbioru td {
								text-align: center;
							}
							
							table.zawartoscZbioru td.left {
								text-align: left;
								padding-left: 4px;
							}
							
							table.zawartoscZbioru td.right {
								text-align: right;
								padding-right: 10px;
							}
							
							table.zawartoscZbioru th.left {
								text-align: left;
								padding-left: 8px;
							}
							
							table.zawartoscZbioru th.right {
								text-align: right;
								padding-right: 10px;
							}
							
							table.formTable {
								width: 720px;
								margin-left: auto;
								margin-right: auto;
							}
							
							table.formTable tr td table.innerTable {
								width: 480px;
								margin-left: auto;
								margin-right: auto;
								margin-top: 20px;
								margin-bottom: 20px;
							}
							
							table.formTable tr td.right {
								width: 30%;
								text-align: right;
								vertical-align: top;
								padding-right: 10px;
								padding-top: 5px;
							}
							
							table.formTable tr td.left {
								width: 70%;
								text-align: left;
								padding-left: 2px;
							}
						</style>
						<script>
						<![CDATA[ 
							var ZBC_XSLT = "ZbiorCentralny_20070903.xslt";
						
							// wykonuje transformacje XSLT
							function transformXML(xml, xslt, params, output, destId) {
								// sprawdzenie dostepnych parserow XSLT
								if (window.ActiveXObject) {
									return transformXMLIE(xml, xslt, params, output, destId);
								} else if (document.implementation && document.implementation.createDocument) {
									return transformXMLMozilla(xml, xslt, params, output, destId);
								} else {
									alert('Transformacja dokumentu XML nie jest mozliwa.');
								}
							}
							
							// wczytuje dokument xml
							function loadXMLIE(xml) {
								var xmlDoc = new ActiveXObject("MSXML2.FreeThreadedDomDocument");
								xmlDoc.async = false;
								xmlDoc.load(xml);
								return xmlDoc;
							}
							
							// wykonuje transformacje XSLT z wykorzystaniem mechanizmow IE
							function transformXMLIE(xml, xslt, params, output, destId) {
								// wczytanie XML
								var xmlDoc =  loadXMLIE(xml);

								// wczytanie i kompilacja XSLT
								if (xslt == undefined) {
									xslt = getXSLTLocation(xmlDoc);
								}
								var xsltDoc = loadXMLIE(xslt);
								var xsltCompl = new ActiveXObject("MSXML2.XSLTemplate");
								xsltCompl.stylesheet = xsltDoc.documentElement;

								// stwowrzenie i konfiguracja procesora XSLT
								var xsltProc = xsltCompl.createProcessor();
								xsltProc.input = xmlDoc;
								for (param in params) {
									xsltProc.addParameter(param, params[param]);
								}

								// transformacja XML
								xsltProc.transform();
								if (destId == undefined) {
									output.write(xsltProc.output);
								} else {
									var outputDiv = output.getElementById(destId);
									outputDiv.innerHTML = xsltProc.output;
									
									var x = outputDiv.getElementsByTagName("script"); 
									for (var i=0; i<x.length; i++) {
										eval(x[i].text);
									}
								}
							}
							
							// wczytuje dokument xml
							function loadXMLMozilla(xml) {
								var xmlDoc = document.implementation.createDocument("", "", null);
								xmlDoc.async = false;
								xmlDoc.load(xml);
								return xmlDoc;
							}
							
							// wykonuje transformacje XSLT z wykorzystaniem mechanizmow Mozilli
							function transformXMLMozilla(xml, xslt, params, output, destId) {
								// wczytanie XML
								var xmlDoc = loadXMLMozilla(xml);
								
								// wczytanie i kompilacja XSLT
								if (xslt == undefined) {
									xslt = getXSLTLocation(xmlDoc);
								}
								var xsltDoc = loadXMLMozilla(xslt);

								// stwowrzenie i konfiguracja procesora XSLT
								var xsltProc = new XSLTProcessor();
								xsltProc.importStylesheet(xsltDoc);
								for (param in params) {
									xsltProc.setParameter(null, param, params[param]);
								}
								
								// transformacja XML
								if (destId == undefined) {
									var outputFrag = xsltProc.transformToFragment(xmlDoc, output);
									output.removeChild(output.childNodes[0]);
									output.childNodes[0].appendChild(outputFrag);
								} else {
									xsltProc.setParameter(null, "transformationDest", destId);
									var outputDoc = xsltProc.transformToDocument(xmlDoc);

									var serializer = new XMLSerializer(); 
									var stringOutput = serializer.serializeToString(outputDoc.documentElement);
									
									var outputDiv = document.getElementById(destId);
									outputDiv.innerHTML = stringOutput;
									
									var scripts = outputDiv.getElementsByTagName("script"); 
									var script = '';
									for (var i=0; i<scripts.length; i++) {
										script += scripts[i].text;
									}
									eval(script);
								}
							}

							// wykonuje transformacje XSLT i wyswietla XML (uzywa podanych parametrow
							// i wynik zapisuje w miejscu wskazanym przez destId)
							function displayXML(params, destId) {
								if (destId == undefined) {
									destId = "bodyDiv";
								}
							
								transformXML(getXMLLocation(), null, params, window.document, destId);
								
								if (dictSelected) {
									hideDictSelection();
								}
								
								// zapamietanie wyswietlonej strony
								rememberCurrentPage();
							}

							function hideDictSelection() {
								var dictFileDiv = document.getElementById('dictFileDiv');
								dictFileDiv.style.visibility = 'hidden';
								dictFileDiv.style.height = '0px';
							}

							// pobiera sciezke pliku XML
							function getXMLLocation() {
								return document.location.href;
							}

							// znajduje sciezke do XSLT (na podstawie naglowka dokumentu XML)
							function getXSLTLocation(xmlDoc) {
								for (i = 0; i < xmlDoc.childNodes.length; i++) {
									var elem = xmlDoc.childNodes.item(i);
									if (elem.nodeName == "xml-stylesheet") {
										return parseXSLTRef(elem.nodeValue);
									}
								}
								// zwrocenie wartosci domyslnej
								return ZBC_XSLT;
							}
							
							// analizuje wartosc elementu "xml-stylesheet" w poszukiwaniu sciezki XSLT
							function parseXSLTRef(href) {
								return href.replace(/.*href\s*=\s*\"([^"]*)\"/, "$1");
							}
						]]>
						</script>
						<script>
							// parametry
							var currentParams = {};
							currentParams.context = '<xsl:value-of select="$context"/>';
							currentParams.contextParamNrSpraw = '<xsl:value-of select="$contextParamNrSpraw"/>';
							currentParams.contextParamIdOsoby = '<xsl:value-of select="$contextParamIdOsoby"/>';
							currentParams.contextParamKodZrFin = '<xsl:value-of select="$contextParamKodZrFin"/>';
							currentParams.page = <xsl:value-of select="$page"/>;
							currentParams.pageSize = <xsl:value-of select="$pageSize"/>;
							currentParams.filterColumn = '<xsl:value-of select="$filterColumn"/>';
							currentParams.filterPattern = '<xsl:value-of select="$filterPattern"/>';

							// kopiuje parametry
							function copyParams(params) {
								var newParams = {};
								for (p in params) {
									newParams[p] = params[p];
								}
								return newParams;
							}
						</script>
						<script>
							var histHTML = {};
							var histParams = {};
							var histPos = 0;
							
							// zapamietuje biezaca strone
							function rememberCurrentPage() {
								var bodyDiv = document.getElementById("bodyDiv");
								histParams[histPos] = copyParams(currentParams);
								histHTML[histPos] = bodyDiv.innerHTML;
								histPos++;
								
								refreshHistoryButton();
							}
							
							// wyswietla poprzednia strone
							function displayPreviousPage() {
								if (histPos > 1) {
									var bodyDiv = document.getElementById("bodyDiv");
									currentParams = copyParams(histParams[histPos - 2]);
									bodyDiv.innerHTML = histHTML[histPos - 2];
									histPos--;
								}
								refreshHistoryButton();
							}
							
							// resetuje historie
							function resetHistory() {
								histHTML = {};
								histParams = {};
								histPos = 0;
								refreshHistoryButton();
							}
							
							// odswieza przycisk powrotu do poprzedniej strony
							function refreshHistoryButton() {
								var button = document.getElementById("historyButton");
								if (button != undefined) {
									if (histPos > 1) {
										button.disabled = "";
									} else {
										button.disabled = "disabled";
									}
								}
							}
						</script>						
						<script>
							// odswieza podlgad (filtruje elementy listy)
							function filter(field, value) {
								currentParams.page = 1;
								currentParams.filterColumn = field;
								currentParams.filterPattern = value;
								displayXML(currentParams);
							}
						</script>
						<script>
							// sprawdza czy zdarzenie bylo spowodowane nacisnieciem klawisza enter
							function isEnterPressed(event) {
								var keynum;
								var keychar;
								var numcheck;
								if(window.event) {
									// Internet Explorer
									keynum = event.keyCode;
								} else if(event.which) {
									// Netscape/Firefox/Opera
									keynum = event.which;
								}
								return keynum == 13;
							}
						</script>
						<script>
							// dane swiadczen (suma kwot i liczb)
							var SW;
							
							function add(key, w1, w2, w3, l1, l2, l3) {
								if (SW[key] == undefined) {
									SW[key] = new Object();
									SW[key]['w1'] = SW[key]['w2'] = SW[key]['w3'] = 0;
									SW[key]['l1'] = SW[key]['l2'] = SW[key]['l3'] = 0;
								}
								SW[key]['w1'] += w1;
								SW[key]['w2'] += w2;
								SW[key]['w3'] += w3;
								SW[key]['l1'] += l1;
								SW[key]['l2'] += l2;
								SW[key]['l3'] += l3;
							}
							
							function createDaneSumaryczne() {
								SW = new Object();

								<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie">
									add('<xsl:value-of select="Kod_Swiad"/>', <xsl:value-of select="Wartosc/Mies_1"/>, <xsl:value-of select="Wartosc/Mies_2"/>, <xsl:value-of select="Wartosc/Mies_3"/>, <xsl:value-of select="Liczba/Mies_1"/>, <xsl:value-of select="Liczba/Mies_2"/>, <xsl:value-of select="Liczba/Mies_3"/>);
								</xsl:for-each>
							}

							// plik z zestawem slownikow
							var ZBC_ZESTAW = "Zestaw.xml";
							var dictSelected = false;
							// tablica slownikow
							var SL = new Object();
							
						<![CDATA[
							// wczytanie zestawu slownikow
							function wczytajZestawSlownikow() {
								try {
									// zaladowanie xml'a zestawu slownikow i uruchomienie parsera
									if (window.ActiveXObject) {
										var xmlDoc = loadXMLIE(ZBC_ZESTAW);
										wczytajZestawSlownikowDoc(xmlDoc);
										dictSelected = true;
										hideDictSelection();
										return true;
									} else if (document.implementation && document.implementation.createDocument) {
										var xmlDoc;
										try {
											xmlDoc = loadXMLMozilla(ZBC_ZESTAW);
										} catch (error) {
											xmlDoc = loadXMLMozilla('file:///' + ZBC_ZESTAW);
										}
										wczytajZestawSlownikowDoc(xmlDoc);
										dictSelected = true;
										hideDictSelection();
										return true;
									} else {
										alert('Pobranie słowników nie jest możliwe, zostaną wyświetlone kody słownikowe.');
										return false;
									}
								} catch (error) {
									alert('Nie udało się wczytać zestawu słowników - wybierz poprawny zestaw słowników');
									return false;
								}
							}
							
							// odczytuje dokument zestawu slownikow
							function wczytajZestawSlownikowDoc(xmlDoc) {
								var slowniki = xmlDoc.getElementsByTagName("Słowniki_ZBC")[0].getElementsByTagName("Słownik");
								for (var i = 0; i < slowniki.length; i++) {
									var slownik = new Object();
									var nazwa = slowniki[i].getElementsByTagName('Nazwa')[0].firstChild.nodeValue;
									SL[nazwa] = slownik;

									var pozycje = slowniki[i].getElementsByTagName('Pozycje')[0].getElementsByTagName('Pozycja');
									for (var j = 0; j < pozycje.length; j++) {
										var pozycja = new Object();
										var kodSpr = pozycje[j].getElementsByTagName('Kod_Spr')[0].firstChild.nodeValue;
										pozycja.kodSpr = kodSpr; 
										pozycja.dataOd = pozycje[j].getElementsByTagName('Data_Od')[0].firstChild.nodeValue;
										var dataDoElem = pozycje[j].getElementsByTagName('Data_Do')[0];
										if (dataDoElem.firstChild != undefined) {
											pozycja.dataDo = dataDoElem.firstChild.nodeValue;
										}
										pozycja.opis = pozycje[j].getElementsByTagName('Opis')[0].firstChild.nodeValue;
										// pozycja zapamietywana jesli wczesniej nie byla zapamietana lub data do jest niezdefiniowana lub pozycja jest starsza niz aktualnie zapamietana
										if (SL[nazwa][kodSpr] == undefined
												|| pozycja.dataDo == undefined
												|| SL[nazwa][kodSpr].dataOd < pozycja.dataOd) {
											SL[nazwa][kodSpr] = pozycja;
										}
									}
								}
							}

							// funkcja pomocnicza zwracajaca rodzaj swiadczenia
							function getRodzajSwiadczenia(kodSwiadczenia) {
								var rodzaj = '';
								var kod = kodSwiadczenia.substring(0, 1);
								if (kod == '1') {
									rodzaj = 'zadania zlecone gminie (razem)';										
								} else if (kod == '2') {
									rodzaj = 'zadania własne gminy (razem)';
								} else if (kod == '3') {
									rodzaj = 'zadania zlecone powiatu (razem)';
								} else if (kod == '4') {
									rodzaj = 'zadania własne powiatu (razem)';
								}
								return rodzaj;
							}

							// wyswietla dane sumaryczne zbioru
							function showDaneSumaryczne() {
								try {
									if (SW == undefined) {
										createDaneSumaryczne();
									}
									
									var dsText = '<fieldset>';
									dsText += '<legend>Dane sumaryczne</legend>';
									dsText += '<table border="px" style="width: 100%" class="zawartoscZbioru">';
									dsText += '<tr>';
									dsText += '<th rowspan="2" style="width: 46%;">Rodzaj</th>';
									dsText += '<th colspan="2" style="width: 18%;">Miesiąc 1</th>';
									dsText += '<th colspan="2" style="width: 18%;">Miesiąc 2</th>';
									dsText += '<th colspan="2" style="width: 18%;">Miesiąc 3</th>';
									dsText += '</tr>';
									dsText += '<tr>';
									dsText += '<th style="width: 9%;">Kwota</th>';
									dsText += '<th style="width: 9%;">Liczba</th>';
									dsText += '<th style="width: 9%;">Kwota</th>';
									dsText += '<th style="width: 9%;">Liczba</th>';
									dsText += '<th style="width: 9%;">Kwota</th>';
									dsText += '<th syle="width: 9%;">Liczba</th>';
									dsText += '</tr>';
										
									var values = new Array();
									var idx = 0;
									for (val in SW) {
										values[idx++] = val;
									}
									
									var sorted = values.sort();
									
									// suma
									var sumVal = new Object();
									sumVal.w1 = sumVal.w2 = sumVal.w3 = 0;
									sumVal.l1 = sumVal.l2 = sumVal.l3 = 0;
									
									var lastType = 0;
									for (var i = 0; i < sorted.length; i++) {
										var type = sorted[i].substring(0, 1);
										// podsumowanie
										if (type != lastType && lastType != 0) {
											dsText += '<tr>';
											dsText += '<th class="left">' + getRodzajSwiadczenia(lastType) + '</th>';										
	
											dsText += '<th class="right">' + sumVal.w1.toFixed(2) + '</th>';
											dsText += '<th class="right">' + sumVal.l1.toFixed(0) + '</th>';
											dsText += '<th class="right">' + sumVal.w2.toFixed(2) + '</th>';
											dsText += '<th class="right">' + sumVal.l2.toFixed(0) + '</th>';
											dsText += '<th class="right">' + sumVal.w3.toFixed(2) + '</th>';
											dsText += '<th class="right">' + sumVal.l3.toFixed(0) + '</th>';
											dsText += '</tr>';
	
											sumVal.w1 = sumVal.w2 = sumVal.w3 = 0;
											sumVal.l1 = sumVal.l2 = sumVal.l3 = 0;
										}
	
										// wiersz
										dsText += '<tr>';
										if (SL['KOD Rodzaju Świadczenia'] != undefined && SL['KOD Rodzaju Świadczenia'][sorted[i]] != undefined) {
											dsText += '<td class="left">' + SL['KOD Rodzaju Świadczenia'][sorted[i]].opis + ' (' + sorted[i] + ')</td>';
										} else if (SL['KOD Świadczenia Pozaustawowego'] != undefined && SL['KOD Świadczenia Pozaustawowego'][sorted[i]] != undefined) {
											dsText += '<td class="left">' + SL['KOD Świadczenia Pozaustawowego'][sorted[i]].opis + ' (' + sorted[i] + ')</td>';
										} else {
											dsText += '<td class="left">' + sorted[i] + '</td>';
										}
										dsText += '<td class="right">' + SW[sorted[i]].w1.toFixed(2) + '</td>';
										dsText += '<td class="right">' + SW[sorted[i]].l1.toFixed(0) + '</td>';
										dsText += '<td class="right">' + SW[sorted[i]].w2.toFixed(2) + '</td>';
										dsText += '<td class="right">' + SW[sorted[i]].l2.toFixed(0) + '</td>';
										dsText += '<td class="right">' + SW[sorted[i]].w3.toFixed(2) + '</td>';
										dsText += '<td class="right">' + SW[sorted[i]].l3.toFixed(0) + '</td>';
										dsText += '</tr>';
										
										lastType = type;

										// modyfikacja statystyk
										sumVal.w1 += SW[sorted[i]].w1;
										sumVal.w2 += SW[sorted[i]].w2;
										sumVal.w3 += SW[sorted[i]].w3;
										sumVal.l1 += SW[sorted[i]].l1;
										sumVal.l2 += SW[sorted[i]].l2;
										sumVal.l3 += SW[sorted[i]].l3;
									}
									
									// ostatnie podsumowanie
									if (lastType != 0) {
										dsText += '<tr>';
										dsText += '<th class="left">' + getRodzajSwiadczenia(lastType) + '</th>';
		
										dsText += '<th class="right">' + sumVal.w1.toFixed(2) + '</th>';
										dsText += '<th class="right">' + sumVal.l1.toFixed(0) + '</th>';
										dsText += '<th class="right">' + sumVal.w2.toFixed(2) + '</th>';
										dsText += '<th class="right">' + sumVal.l2.toFixed(0) + '</th>';
										dsText += '<th class="right">' + sumVal.w3.toFixed(2) + '</th>';
										dsText += '<th class="right">' + sumVal.l3.toFixed(0) + '</th>';
										dsText += '</tr>';
									}
	
									dsText += "</table>"
									dsText += "</fieldset>";
									
									var ds = document.getElementById('daneSumaryczneDiv');
									ds.innerHTML = dsText;
								} catch (error) {
									alert('Nie udało się wyliczyć danych sumarycznych');
								}
							}
							
							//wczytajZestawSlownikow();
						]]>
						</script>
					</head>
					<body onload="wczytajZestawSlownikow(); showDaneSumaryczne();">
						<div id="bodyDiv">
							<xsl:call-template name="Body"/>
						</div>
					</body>
				</html>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Body"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Body">
		<form name="topForm">
			<fieldset>
				<table width="100%">
					<tr>
						<td style="text-align: left; margin-left: 5px; margin-right: auto;">
							<button>
								<xsl:attribute name="onClick">
									resetHistory();

									currentParams = {};
									currentParams.context = 'Zbiory';
									currentParams.page = 1;
									displayXML(currentParams);
									
									showDaneSumaryczne();
								</xsl:attribute>
								<xsl:text>Zbiory</xsl:text>
							</button>
							&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;
							<button>
								<xsl:attribute name="onClick">
									resetHistory();
									
									currentParams = {};
									currentParams.context = 'Swiadczenia';
									currentParams.page = 1;
									displayXML(currentParams);
								</xsl:attribute>
								<xsl:text>Świadczenia</xsl:text>
							</button>
							&#160;
							<button>
								<xsl:attribute name="onClick">
									resetHistory();
									
									currentParams = {};
									currentParams.context = 'Wydatki';
									currentParams.page = 1;
									displayXML(currentParams);
								</xsl:attribute>
								<xsl:text>Wydatki</xsl:text>
							</button>
							&#160;
							<button>
								<xsl:attribute name="onClick">
									resetHistory();
									
									currentParams = {};
									currentParams.context = 'DecyzjeOdmowne';
									currentParams.page = 1;
									displayXML(currentParams);
								</xsl:attribute>
								<xsl:text>Decyzje Odmowne</xsl:text>
							</button>
							&#160;
							<button>
								<xsl:attribute name="onClick">
									resetHistory();
									
									currentParams = {};
									currentParams.context = 'Wnioski';
									currentParams.page = 1;
									displayXML(currentParams);
								</xsl:attribute>
								<xsl:text>Wnioski</xsl:text>
							</button>
						</td>
						<td style="text-align: right; margin-right: 5px;">
							<button id="historyButton">
								<xsl:attribute name="onClick">
									displayPreviousPage();
								</xsl:attribute>
								<xsl:text>&lt;&lt; Wstecz</xsl:text>
							</button>
						</td>
					</tr>
				</table>
			</fieldset>

			<div id="dictFileDiv">			
				<br/>
				<fieldset>
					<table width="100%">
						<tr>
							<td style="text-align: right; margin-right: 25px;">
								<input type="file" name="dictFile" size="50"/>
								&#160;
								<button id="historyButton" type="button">
									<xsl:attribute name="onClick">
										ZBC_ZESTAW = document.forms['topForm'].dictFile.value;
										if (wczytajZestawSlownikow()) {
											displayXML(currentParams);
											
											if (currentParams.context == 'Zbiory') {
											showDaneSumaryczne();
											}
										}
									</xsl:attribute>
									<xsl:text>Załaduj zestaw słowników</xsl:text>
								</button>
							</td>
						</tr>
					</table>
				</fieldset>
			</div>
		</form>
		<br/>
		
		<xsl:choose>
			<xsl:when test="$context = 'Zbiory'">
				<xsl:call-template name="Zbiory"/>
			</xsl:when>
			<xsl:when test="$context = 'Swiadczenia'">
				<xsl:call-template name="Swiadczenia"/>
			</xsl:when>
			<xsl:when test="$context = 'Swiadczenie'">
				<xsl:call-template name="Swiadczenie"/>
			</xsl:when>
			<xsl:when test="$context = 'Wydatki'">
				<xsl:call-template name="Wydatki"/>
			</xsl:when>
			<xsl:when test="$context = 'Wydatek'">
				<xsl:call-template name="Wydatek"/>
			</xsl:when>
			<xsl:when test="$context = 'DecyzjeOdmowne'">
				<xsl:call-template name="DecyzjeOdmowne"/>
			</xsl:when>
			<xsl:when test="$context = 'DecyzjaOdmowna'">
				<xsl:call-template name="DecyzjaOdmowna"/>
			</xsl:when>
			<xsl:when test="$context = 'Wnioski'">
				<xsl:call-template name="Wnioski"/>
			</xsl:when>
			<xsl:when test="$context = 'Wniosek'">
				<xsl:call-template name="Wniosek"/>
			</xsl:when>
			<xsl:when test="$context = 'CzlonkowieRodziny'">
				<xsl:call-template name="CzlonkowieRodziny"/>
			</xsl:when>
			<xsl:when test="$context = 'CzlonekRodziny'">
				<xsl:call-template name="CzlonekRodziny"/>
			</xsl:when>
			<xsl:when test="$context = 'ZrodlaFinansowania'">
				<xsl:call-template name="ZrodlaFinansowania"/>
			</xsl:when>
			<xsl:when test="$context = 'ZrodloFinansowania'">
				<xsl:call-template name="ZrodloFinansowania"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Zbiory"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Zbiory">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny">
			<form name="zbiory">
				<fieldset>
					<legend>Dane zbioru centralnego</legend>
					<table style="width: 100%;">
						<tr>
							<td style="width: 25%;" class="label">Rok:</td>
							<td style="width: 25%;" class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Za_Okres/Rok"/>
								</xsl:call-template>
							</td>
							<td style="width: 25%;" class="label">Kwartał:</td>
							<td style="width: 25%;" class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Za_Okres/Kwartal"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td class="label">Nr wykonania:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Nr_Wykonania_Zbc"/>
								</xsl:call-template>
							</td>
							<td class="label">Data utworzenia:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Data_Utworzenia"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td class="label">Wersja WH:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="/P_ZBRCEN/@Wersja_Wymagan"/>
								</xsl:call-template>
							</td>
							<td class="label">Wersja formularza:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="/P_ZBRCEN/@Wersja_Formularza"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</fieldset>
				<br/>
				<fieldset>
					<legend>Dane jednostki utworzenia</legend>
					<table width="100%">
						<tr>
							<td style="width: 25%;" class="label">Keso:</td>
							<td style="width: 25%; vertical-align: top;" class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="/P_ZBRCEN/Metryczka/Nadawca/@Kod_KESO"/>
								</xsl:call-template>
							</td>
							<td style="width: 25%;" class="label">Nazwa:</td>
							<td style="width: 25%;" class="left">
								<textarea rows="2" cols="20" class="disabled" readonly="readonly">
									<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/Pelna_Nazwa"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td class="label">Kod aplikacji:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="/P_ZBRCEN/@Kod_Aplikacji"/>
								</xsl:call-template>
							</td>
							<td class="label">Wersja aplikacji:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="/P_ZBRCEN/@Wersja_Aplikacji"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td class="label">Liczba rodzin w systemie:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Liczba_Rodzin_W_Systemie"/>
								</xsl:call-template>
							</td>
							<td class="label">Liczba wywiadów:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Liczba_Utworzonych_Wywiadow"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td class="label">Zestaw słowników nr:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="Nr_Zestawu_Slownikow"/>
								</xsl:call-template>
							</td>
							<td class="label">Liczba świadczeń:</td>
							<td class="left">
								<xsl:call-template name="Input">
									<xsl:with-param name="value" select="count(Swiadczenia/Swiadczenie)"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</fieldset>
				<br/>
				<fieldset>
					<legend>Zawartość</legend>
					<table border="px" style="width: 100%" class="zawartoscZbioru">
						<tr>
							<th style="width: 28%;">Informacja</th>
							<th style="width: 18%;">Kwartał 1</th>
							<th style="width: 18%;">Kwartał 2</th>
							<th style="width: 18%;">Kwartał 3</th>
							<th style="width: 18%;">Kwartał 4</th>
						</tr>
						<tr>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="'Wartość świadczeń POMOST'"/>
								<xsl:with-param name="class" select="'left'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw1"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw2"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw3"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/POMOST/Kw4"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="'Wartość świadczeń RB28-S'"/>
								<xsl:with-param name="class" select="'left'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw1"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw2"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw3"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Wartosc_Swiadczen/RB28-S/Kw4"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="'Procent zgodności'"/>
								<xsl:with-param name="class" select="'left'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw1"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw2"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw3"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
							<xsl:call-template name="TableCell">
								<xsl:with-param name="value" select="Procent_Zgodnosci/Kw4"/>
								<xsl:with-param name="class" select="'right'"/>
							</xsl:call-template>
						</tr>
					</table>
				</fieldset>
				<br/>
				<div id="daneSumaryczneDiv"/>
			</form>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Swiadczenia">
		<fieldset>
			<legend>Świadczenia</legend>
			<xsl:choose>
				<xsl:when test="$filterColumn = 'Kod_Swiad' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Kod_Swiad, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Pier_Sw' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Data_Pier_Sw, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Okr_Swiad' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Okr_Swiad, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Czy_Dla_Rodz' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Czy_Dla_Rodz, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Liczba/Mies_1' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Liczba/Mies_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Liczba/Mies_2' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Liczba/Mies_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Liczba/Mies_3' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Liczba/Mies_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Wartosc/Mies_1' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Wartosc/Mies_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Wartosc/Mies_2' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Wartosc/Mies_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Wartosc/Mies_3' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Wartosc/Mies_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'St_Odpl' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(St_Odpl, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Kod_Pow_Ust_Pom' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Kod_Pow_Ust_Pom, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Problemy/Kod_1' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Problemy/Kod_2' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Problemy/Kod_3' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Problemy/Kod_4' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_4, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Problemy/Kod_5' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_5, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>

			<table border="1px" style="width: 100%">
				<xsl:call-template name="SwiadczenieNaglowek"/>
				
				<xsl:choose>
					<xsl:when test="$filterColumn = 'Kod_Swiad' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Kod_Swiad, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Pier_Sw' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Data_Pier_Sw, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Okr_Swiad' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Okr_Swiad, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Czy_Dla_Rodz' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Czy_Dla_Rodz, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Liczba/Mies_1' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Liczba/Mies_1, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Liczba/Mies_2' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Liczba/Mies_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Liczba/Mies_3' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Liczba/Mies_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Wartosc/Mies_1' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Wartosc/Mies_1, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Wartosc/Mies_2' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Wartosc/Mies_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Wartosc/Mies_3' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Wartosc/Mies_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'St_Odpl' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(St_Odpl, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Kod_Pow_Ust_Pom' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Kod_Pow_Ust_Pom, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Problemy/Kod_1' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_1, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Problemy/Kod_2' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Problemy/Kod_3' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Problemy/Kod_4' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_4, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Problemy/Kod_5' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[contains(Problemy/Kod_5, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="SwiadczenieWiersz"/>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			<xsl:call-template name="SwiadczeniaFiltr"/>
		</fieldset>
	</xsl:template>
	<xsl:template name="SwiadczeniaFiltr">
		<form name="swiadczenia">
			<div class="tableFilter">
				<table>
					<tr>
						<td>
							<select name="kolumna">
								<option value="Kod_Swiad">
									<xsl:if test="$filterColumn = 'Kod_Swiad'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia</xsl:text>
								</option>
								<option value="Data_Pier_Sw">
									<xsl:if test="$filterColumn = 'Data_Pier_Sw'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Data pierwszego świadczenia</xsl:text>
								</option>
								<option value="Okr_Swiad">
									<xsl:if test="$filterColumn = 'Okr_Swiad'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Okres świadczenia</xsl:text>
								</option>
								<option value="Czy_Dla_Rodz">
									<xsl:if test="$filterColumn = 'Czy_Dla_Rodz'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Czy dla rodziny</xsl:text>
								</option>
								<option value="Liczba/Mies_1">
									<xsl:if test="$filterColumn = 'Liczba/Mies_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Liczba miesiąc 1</xsl:text>
								</option>
								<option value="Liczba/Mies_2">
									<xsl:if test="$filterColumn = 'Liczba/Mies_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Liczba miesiąc 2</xsl:text>
								</option>
								<option value="Liczba/Mies_3">
									<xsl:if test="$filterColumn = 'Liczba/Mies_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Liczba miesiąc 3</xsl:text>
								</option>
								<option value="Wartosc/Mies_1">
									<xsl:if test="$filterColumn = 'Wartosc/Mies_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Wartość miesiąc 1</xsl:text>
								</option>
								<option value="Wartosc/Mies_2">
									<xsl:if test="$filterColumn = 'Wartosc/Mies_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Wartość miesiąc 2</xsl:text>
								</option>
								<option value="Wartosc/Mies_3">
									<xsl:if test="$filterColumn = 'Wartosc/Mies_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Wartość miesiąc 3</xsl:text>
								</option>
								<option value="St_Odpl">
									<xsl:if test="$filterColumn = 'St_Odpl'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Stopa odpłatności</xsl:text>
								</option>
								<option value="Kod_Pow_Ust_Pom">
									<xsl:if test="$filterColumn = 'Kod_Pow_Ust_Pom'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Powód ustania pomocy</xsl:text>
								</option>
								<option value="Problemy/Kod_1">
									<xsl:if test="$filterColumn = 'Problemy/Kod_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod problemu 1</xsl:text>
								</option>
								<option value="Problemy/Kod_2">
									<xsl:if test="$filterColumn = 'Problemy/Kod_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod problemu 2</xsl:text>
								</option>
								<option value="Problemy/Kod_3">
									<xsl:if test="$filterColumn = 'Problemy/Kod_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod problemu 3</xsl:text>
								</option>
								<option value="Problemy/Kod_4">
									<xsl:if test="$filterColumn = 'Problemy/Kod_4'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod problemu 4</xsl:text>
								</option>
								<option value="Problemy/Kod_5">
									<xsl:if test="$filterColumn = 'Problemy/Kod_5'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod problemu 5</xsl:text>
								</option>
							</select>
						</td>
						<td>
							<input name="wartosc" type="text">
								<xsl:attribute name="onKeyPress">
									if (isEnterPressed(event)) {
										filter(document.forms['swiadczenia'].elements['kolumna'].value, document.forms['swiadczenia'].elements['wartosc'].value);
									}
								</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="$filterPattern"/>
								</xsl:attribute>
							</input>
						</td>
						<td>
							<button>
								<xsl:attribute name="onClick">
									filter(document.forms['swiadczenia'].elements['kolumna'].value, document.forms['swiadczenia'].elements['wartosc'].value);
								</xsl:attribute>
								<xsl:text>Filtruj</xsl:text>
							</button>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</xsl:template>
	<xsl:template name="SwiadczenieNaglowek">
		<tr>
			<th style="width: 10%;">Lp.</th>
			<th style="width: 55%;">Świadczenie</th>
			<th style="width: 20%;">Data pierwszego świadczenia</th>
			<th style="width: 15%;">Czy dla rodziny</th>
			<th style="width: 0%;">&#160;</th>
		</tr>
	</xsl:template>
	<xsl:template name="SwiadczenieWiersz" match="Swiadczenie">
		<tr>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="position()"/>
			</xsl:call-template>
			<xsl:call-template name="DynamicTableCell">
				<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
				<xsl:with-param name="code" select="Kod_Swiad"/>
				<xsl:with-param name="class" select="'left'"/>
			</xsl:call-template>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="Data_Pier_Sw"/>
			</xsl:call-template>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="Czy_Dla_Rodz"/>
			</xsl:call-template>
			<td>
				<button>
					<xsl:attribute name="onClick">
						currentParams.context = 'Swiadczenie';
						currentParams.contextParamNrSpraw = '<xsl:value-of select="Nr_Spr"/>';
						displayXML(currentParams);
					</xsl:attribute>
					<xsl:text>Pokaż</xsl:text>
				</button>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Swiadczenie">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[Nr_Spr = $contextParamNrSpraw]">
			<fieldset>
				<legend>Świadczenie</legend>
				<table class="formTable">
					<tr>
						<td class="label">Świadczenie:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
								<xsl:with-param name="code" select="Kod_Swiad"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Data pierwszego świadczenia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Pier_Sw"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Okres świadczenia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Okr_Swiad"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Czy dla rodziny:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Czy_Dla_Rodz"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Miesiąc</th>
									<th style="width: 40%;">Liczba</th>
									<th style="width: 40%;">Wartość</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Liczba/Mies_1"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_1"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Liczba/Mies_2"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_2"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Liczba/Mies_3"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_3"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="label">Stopa odpł.:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="St_Odpl"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Powód ustania pomocy:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Powodu Ustania Pomocy'"/>
								<xsl:with-param name="code" select="Kod_Pow_Ust_Pom"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Numer</th>
									<th style="width: 80%;">Problem</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Problemu'"/>
										<xsl:with-param name="code" select="Problemy/Kod_1"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
									
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Problemu'"/>
										<xsl:with-param name="code" select="Problemy/Kod_2"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Problemu'"/>
										<xsl:with-param name="code" select="Problemy/Kod_3"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>4</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Problemu'"/>
										<xsl:with-param name="code" select="Problemy/Kod_4"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>5</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Problemu'"/>
										<xsl:with-param name="code" select="Problemy/Kod_5"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</fieldset>
			<br/>

			<xsl:call-template name="SytuacjaRodziny">
				<xsl:with-param name="idSytRodz" select="Id_Syt_Rodz"/>
			</xsl:call-template>
			<br/>

			<xsl:call-template name="CzlonkowieRodziny"/>
			<br/>
			
			<xsl:call-template name="ZrodlaFinansowania"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Wydatki">
		<fieldset>
			<legend>Wydatki</legend>
			<xsl:choose>
				<xsl:when test="$filterColumn = 'Kod_Swiad' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Kod_Swiad, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Pier_Sw' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Data_Pier_Sw, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Liczba/Mies_1' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Liczba/Mies_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Liczba/Mies_2' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Liczba/Mies_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Liczba/Mies_3' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Liczba/Mies_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Wartosc/Mies_1' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Wartosc/Mies_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Wartosc/Mies_2' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Wartosc/Mies_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Wartosc/Mies_3' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Wartosc/Mies_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			
			<table border="1" width="100%">
				<xsl:call-template name="WydatkiNaglowek"/>
				
				<xsl:choose>
					<xsl:when test="$filterColumn = 'Kod_Swiad' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Kod_Swiad, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Pier_Sw' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Data_Pier_Sw, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Liczba/Mies_1' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Liczba/Mies_1, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Liczba/Mies_2' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Liczba/Mies_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Liczba/Mies_3' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Liczba/Mies_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Wartosc/Mies_1' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Wartosc/Mies_1, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Wartosc/Mies_2' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Wartosc/Mies_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Wartosc/Mies_3' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[contains(Wartosc/Mies_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WydatekWiersz"/>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			
			<xsl:call-template name="WydatkiFiltr"/>
		</fieldset>
	</xsl:template>
	<xsl:template name="WydatkiFiltr">
		<form name="wydatki">
			<div class="tableFilter">
				<table>
					<tr>
						<td>
							<select name="kolumna">
								<option value="Kod_Swiad">
									<xsl:if test="$filterColumn = 'Kod_Swiad'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia</xsl:text>
								</option>
								<option value="Data_Pier_Sw">
									<xsl:if test="$filterColumn = 'Data_Pier_Sw'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Data pierwszego świadczenia</xsl:text>
								</option>
								<option value="Liczba/Mies_1">
									<xsl:if test="$filterColumn = 'Liczba/Mies_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Liczba miesiąc 1</xsl:text>
								</option>
								<option value="Liczba/Mies_2">
									<xsl:if test="$filterColumn = 'Liczba/Mies_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Liczba miesiąc 2</xsl:text>
								</option>
								<option value="Liczba/Mies_3">
									<xsl:if test="$filterColumn = 'Liczba/Mies_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Liczba miesiąc 3</xsl:text>
								</option>
								<option value="Wartosc/Mies_1">
									<xsl:if test="$filterColumn = 'Wartosc/Mies_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Wartość miesiąc 1</xsl:text>
								</option>
								<option value="Wartosc/Mies_2">
									<xsl:if test="$filterColumn = 'Wartosc/Mies_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Wartość miesiąc 2</xsl:text>
								</option>
								<option value="Wartosc/Mies_3">
									<xsl:if test="$filterColumn = 'Wartosc/Mies_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Wartość miesiąc 3</xsl:text>
								</option>
							</select>
						</td>
						<td>
							<input name="wartosc" type="text">
								<xsl:attribute name="onKeyPress">
									if (isEnterPressed(event)) {
										filter(document.forms['wydatki'].elements['kolumna'].value, document.forms['wydatki'].elements['wartosc'].value);
									}
								</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="$filterPattern"/>
								</xsl:attribute>
							</input>
						</td>
						<td>
							<button>
								<xsl:attribute name="onClick">
									filter(document.forms['wydatki'].elements['kolumna'].value, document.forms['wydatki'].elements['wartosc'].value);
								</xsl:attribute>
								<xsl:text>Filtruj</xsl:text>
							</button>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</xsl:template>
	<xsl:template name="WydatkiNaglowek">
		<tr>
			<th style="width: 10%;">Lp.</th>
			<th style="width: 60%;">Świadczenie</th>
			<th style="width: 30%;">Data pierwszego świadczenia</th>
			<th style="width: 0%;">&#160;</th>
		</tr>
	</xsl:template>
	<xsl:template name="WydatekWiersz" match="Wyd_Srodkowi">
		<tr>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="position()"/>
			</xsl:call-template>
			<xsl:call-template name="DynamicTableCell">
				<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
				<xsl:with-param name="code" select="Kod_Swiad"/>
				<xsl:with-param name="class" select="'left'"/>
			</xsl:call-template>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="Data_Pier_Sw"/>
			</xsl:call-template>
			<td>
				<button>
					<xsl:attribute name="onClick">
						currentParams.context = 'Wydatek';
						currentParams.contextParamNrSpraw = '<xsl:value-of select="Nr_Spr"/>';
						displayXML(currentParams);
					</xsl:attribute>
					<xsl:text>Pokaż</xsl:text>
				</button>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Wydatek">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wydatki_Srodkow/Wyd_Srodkow[Nr_Spr = $contextParamNrSpraw]">
			<fieldset>
				<legend>Wydatek</legend>
				<table class="formTable">
					<tr>
						<td class="label">Kod rodzaju świadczenia:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
								<xsl:with-param name="code" select="Kod_Swiad"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Data pierwszego świadczenia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Pier_Sw"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Miesiąc</th>
									<th style="width: 40%;">Liczba</th>
									<th style="width: 40%;">Wartość</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Liczba/Mies_1"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_1"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Liczba/Mies_2"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_2"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Liczba/Mies_3"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_3"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</fieldset>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="DecyzjeOdmowne">
		<fieldset>
			<legend>Decyzje odmowne</legend>
			<xsl:choose>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Data_Podjecia, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Swiad_Odm/Kod_Rodz_1' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Swiad_Odm/Kod_Rodz_2' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Swiad_Odm/Kod_Rodz_3' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_4, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_5, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Pow_Odm/Kod_1, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Pow_Odm/Kod_2, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Pow_Odm/Kod_3, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Kod_Rodz_Wnioskod, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			
			<table border="1" width="100%">
				<xsl:call-template name="DecyzjeOdmowneNaglowek"/>
			
				<xsl:choose>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Data_Podjecia, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Swiad_Odm/Kod_Rodz_1' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Data_Podjecia, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Swiad_Odm/Kod_Rodz_2' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Swiad_Odm/Kod_Rodz_3' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_4, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Swiad_Odm/Kod_Rodz_5, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Pow_Odm/Kod_1, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Pow_Odm/Kod_2, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Pow_Odm/Kod_3, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Podjecia' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[contains(Kod_Rodz_Wnioskod, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Data_Podjecia" order="ascending"/>
							<xsl:call-template name="DecyzjaOdmownaWiersz"/>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			
			<xsl:call-template name="DecyzjeOdmowneFiltr"/>
		</fieldset>
	</xsl:template>
	<xsl:template name="DecyzjeOdmowneFiltr">
		<form name="decyzjeOdmowne">
			<div class="tableFilter">
				<table>
					<tr>
						<td>
							<select name="kolumna">
								<option value="Data_Podjecia">
									<xsl:if test="$filterColumn = 'Data_Podjecia'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Data podjęcia</xsl:text>
								</option>
								<option value="Swiad_Odm/Kod_Rodz_1">
									<xsl:if test="$filterColumn = 'Swiad_Odm/Kod_Rodz_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia 1</xsl:text>
								</option>
								<option value="Swiad_Odm/Kod_Rodz_2">
									<xsl:if test="$filterColumn = 'Swiad_Odm/Kod_Rodz_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia 2</xsl:text>
								</option>
								<option value="Swiad_Odm/Kod_Rodz_3">
									<xsl:if test="$filterColumn = 'Swiad_Odm/Kod_Rodz_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia 3</xsl:text>
								</option>
								<option value="Swiad_Odm/Kod_Rodz_4">
									<xsl:if test="$filterColumn = 'Swiad_Odm/Kod_Rodz_4'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia 4</xsl:text>
								</option>
								<option value="Swiad_Odm/Kod_Rodz_5">
									<xsl:if test="$filterColumn = 'Swiad_Odm/Kod_Rodz_5'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod świadczenia 5</xsl:text>
								</option>
								<option value="Pow_Odm/Kod_1">
									<xsl:if test="$filterColumn = 'Pow_Odm/Kod_1'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Powód odmowy 1</xsl:text>
								</option>
								<option value="Pow_Odm/Kod_2">
									<xsl:if test="$filterColumn = 'Pow_Odm/Kod_2'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Powód odmowy 2</xsl:text>
								</option>
								<option value="Pow_Odm/Kod_3">
									<xsl:if test="$filterColumn = 'Pow_Odm/Kod_3'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Powód odmowy 3</xsl:text>
								</option>
								<option value="Kod_Rodz_Wnioskod">
									<xsl:if test="$filterColumn = 'Kod_Rodz_Wnioskod'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod rodzaju wnioskodawcy</xsl:text>
								</option>
							</select>
						</td>
						<td>
							<input name="wartosc" type="text">
								<xsl:attribute name="onKeyPress">
									if (isEnterPressed(event)) {
										filter(document.forms['decyzjeOdmowne'].elements['kolumna'].value, document.forms['decyzjeOdmowne'].elements['wartosc'].value);
									}
								</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="$filterPattern"/>
								</xsl:attribute>
							</input>
						</td>
						<td>
							<button>
								<xsl:attribute name="onClick">
									filter(document.forms['decyzjeOdmowne'].elements['kolumna'].value, document.forms['decyzjeOdmowne'].elements['wartosc'].value);
								</xsl:attribute>
								<xsl:text>Filtruj</xsl:text>
							</button>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</xsl:template>
	<xsl:template name="DecyzjeOdmowneNaglowek">
		<tr>
			<th style="width: 10%;">Lp.</th>
			<th style="width: 30%;">Data podjęcia</th>
			<th style="width: 60%;">Rodzaj</th>
			<th style="width: 0%;">&#160;</th>
		</tr>
	</xsl:template>
	<xsl:template name="DecyzjaOdmownaWiersz" match="Dec_Odmowna">
		<tr>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="position()"/>
			</xsl:call-template>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="Data_Podjecia"/>
			</xsl:call-template>
			<xsl:call-template name="DynamicTableCell">
				<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
				<xsl:with-param name="code" select="Swiad_Odm/Kod_Rodz_1"/>
				<xsl:with-param name="class" select="'left'"/>
			</xsl:call-template>
			<td>
				<button>
					<xsl:attribute name="onClick">
						currentParams.context = 'DecyzjaOdmowna';
						currentParams.contextParamNrSpraw = '<xsl:value-of select="Nr_Spr"/>';
						displayXML(currentParams);
					</xsl:attribute>
					<xsl:text>Pokaż</xsl:text>
				</button>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="DecyzjaOdmowna">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna[Nr_Spr = $contextParamNrSpraw]">
			<fieldset>
				<legend>Decyzja odmowna</legend>
				<table class="formTable">
					<tr>
						<td class="label">Data podjęcia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Podjecia"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Kod rodzaju wnioskodawcy:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Wnioskodawcy'"/>
								<xsl:with-param name="code" select="Kod_Rodz_Wnioskod"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Numer</th>
									<th style="width: 80%;">Kod świadczenia</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
										<xsl:with-param name="code" select="Swiad_Odm/Kod_Rodz_1"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
										<xsl:with-param name="code" select="Swiad_Odm/Kod_Rodz_2"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
										<xsl:with-param name="code" select="Swiad_Odm/Kod_Rodz_3"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>4</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
										<xsl:with-param name="code" select="Swiad_Odm/Kod_Rodz_4"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>5</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Świadczenia'"/>
										<xsl:with-param name="code" select="Swiad_Odm/Kod_Rodz_5"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Numer</th>
									<th style="width: 80%;">Powód odmowy</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Powodu Odmownej Decyzji'"/>
										<xsl:with-param name="code" select="Pow_Odm/Kod_1"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Powodu Odmownej Decyzji'"/>
										<xsl:with-param name="code" select="Pow_Odm/Kod_2"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Powodu Odmownej Decyzji'"/>
										<xsl:with-param name="code" select="Pow_Odm/Kod_3"/>
										<xsl:with-param name="class" select="'left'"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</fieldset>
			<br/>
			
			<xsl:call-template name="SytuacjaRodziny">
				<xsl:with-param name="idSytRodz" select="Id_Syt_Rodz"/>
			</xsl:call-template>
			<br/>
			
			<xsl:call-template name="SytuacjaOsoby">
				<xsl:with-param name="idSytOsoby" select="Id_Syt_Osoby"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Wnioski">
		<fieldset>
			<legend>Wnioski</legend>
			<xsl:choose>
				<xsl:when test="$filterColumn = 'Kod_Typu' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Kod_Typu, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Wplyn' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Data_Wplyn, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Kod_Rodz_Wnioskod' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Kod_Rodz_Wnioskod, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Kod_Pow_Zamk_Spr' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Kod_Pow_Zamk_Spr, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Zamk_Spr' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Data_Zamk_Spr, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$filterColumn = 'Data_Przek_Do_Dec' and $filterPattern != ''">
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Data_Przek_Do_Dec, $filterPattern)])"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="TableHeader">
						<xsl:with-param name="total">
							<xsl:value-of select="count(/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			
			<table border="1" width="100%">
				<xsl:call-template name="WnioskiNaglowek"/>
				
				<xsl:choose>
					<xsl:when test="$filterColumn = 'Kod_Typu' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Kod_Typu, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Typu" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Wplyn' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Data_Wplyn, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Typu" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Kod_Rodz_Wnioskod' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Kod_Rodz_Wnioskod, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Typu" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Kod_Pow_Zamk_Spr' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Kod_Pow_Zamk_Spr, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Typu" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Zamk_Spr' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Data_Zamk_Spr, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Typu" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="$filterColumn = 'Data_Przek_Do_Dec' and $filterPattern != ''">
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[contains(Data_Przek_Do_Dec, $filterPattern)][position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Typu" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[position() &gt;= $firstRow and position() &lt;= $lastRow]">
							<xsl:sort select="Kod_Swiad" order="ascending"/>
							<xsl:call-template name="WniosekWiersz"/>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			
			<xsl:call-template name="WnioskiFiltr"/>
		</fieldset>
	</xsl:template>
	<xsl:template name="WnioskiFiltr">
		<form name="wnioski">
			<div class="tableFilter">
				<table>
					<tr>
						<td>
							<select name="kolumna">
								<option value="Kod_Typu">
									<xsl:if test="$filterColumn = 'Kod_Typu'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod typu</xsl:text>
								</option>
								<option value="Data_Wplyn">
									<xsl:if test="$filterColumn = 'Data_Wplyn'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Data wpłynięcia</xsl:text>
								</option>
								<option value="Kod_Rodz_Wnioskod">
									<xsl:if test="$filterColumn = 'Kod_Rodz_Wnioskod'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod rodzaju wnioskodawcy</xsl:text>
								</option>
								<option value="Kod_Pow_Zamk_Spr">
									<xsl:if test="$filterColumn = 'Kod_Pow_Zamk_Spr'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Kod powodu zamknięcia</xsl:text>
								</option>
								<option value="Data_Zamk_Spr">
									<xsl:if test="$filterColumn = 'Data_Zamk_Spr'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Data zamknięcia</xsl:text>
								</option>
								<option value="Data_Przek_Do_Dec">
									<xsl:if test="$filterColumn = 'Data_Przek_Do_Dec'">
										<xsl:attribute name="selected">selected</xsl:attribute>
									</xsl:if>
									<xsl:text>Data przekazania do decyzji</xsl:text>
								</option>
							</select>
						</td>
						<td>
							<input name="wartosc" type="text">
								<xsl:attribute name="onKeyPress">
									if (isEnterPressed(event)) {
										filter(document.forms['wnioski'].elements['kolumna'].value, document.forms['wnioski'].elements['wartosc'].value);
									}
								</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="$filterPattern"/>
								</xsl:attribute>
							</input>
						</td>
						<td>
							<button>
								<xsl:attribute name="onClick">
									filter(document.forms['wnioski'].elements['kolumna'].value, document.forms['wnioski'].elements['wartosc'].value);
								</xsl:attribute>
								<xsl:text>Filtruj</xsl:text>
							</button>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</xsl:template>
	<xsl:template name="WnioskiNaglowek">
		<tr>
			<th style="width: 10%;">Lp.</th>
			<th style="width: 25%;">Data wpłynięcia</th>
			<th style="width: 25%;">Data przekazania do decyzji</th>
			<th style="width: 40%;">Typ</th>
			<th style="width: 0%;">&#160;</th>
		</tr>
	</xsl:template>
	<xsl:template name="WniosekWiersz" match="Wniosek">
		<tr>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="position()"/>
			</xsl:call-template>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="Data_Wplyn"/>
			</xsl:call-template>
			<xsl:call-template name="TableCell">
				<xsl:with-param name="value" select="Data_Przek_Do_Dec"/>
			</xsl:call-template>
			<xsl:call-template name="DynamicTableCell">
				<xsl:with-param name="dict" select="'KOD Typu Sprawozdawczego Wniosku'"/>
				<xsl:with-param name="code" select="Kod_Typu"/>
				<xsl:with-param name="class" select="'left'"/>
			</xsl:call-template>
			<td>
				<button>
					<xsl:attribute name="onClick">
						currentParams.context = 'Wniosek';
						currentParams.contextParamNrSpraw = '<xsl:value-of select="Nr_Spr"/>';
						displayXML(currentParams);
					</xsl:attribute>
					<xsl:text>Pokaż</xsl:text>
				</button>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Wniosek">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek[Nr_Spr = $contextParamNrSpraw]">
			<fieldset>
				<legend>Wniosek</legend>
				<table class="formTable">
					<tr>
						<td class="label">Typ sprawozdawczy wniosku:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Typu Sprawozdawczego Wniosku'"/>
								<xsl:with-param name="code" select="Kod_Typu"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Data wpynięcia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Wplyn"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Rodzaj wnioskodawcy:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Wnioskodawcy'"/>
								<xsl:with-param name="code" select="Kod_Rodz_Wnioskod"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Powód zamknięcia:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Powodu Zamknięcia Sprawy'"/>
								<xsl:with-param name="code" select="Kod_Pow_Zamk_Spr"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Data zamknięcia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Zamk_Spr"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Data przekazania do decyzji:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Przek_Do_Dec"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</fieldset>
			<br/>
			
			<xsl:call-template name="SytuacjaRodziny">
				<xsl:with-param name="idSytRodz" select="Id_Syt_Rodz"/>
			</xsl:call-template>
			<br/>
			
			<xsl:call-template name="SytuacjaOsoby">
				<xsl:with-param name="idSytOsoby" select="Id_Syt_Osoby"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="CzlonkowieRodziny">
		<fieldset>
			<legend>Członkowie rodziny</legend>
			<table border="1" width="100%">
				<tr>
					<th style="width: 10%;">Lp.</th>
					<th style="width: 15%;">Płeć</th>
					<th style="width: 15%;">Czy świadczeniobiorca</th>
					<th style="width: 60%;">Rodzaj beneficjenta</th>
					<th style="width: 0%;">&#160;</th>
				</tr>
				
				<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[Nr_Spr = $contextParamNrSpraw]/Czlonkowie_Rodz/Czlonek_Rodz">
					<xsl:sort select="Kod_Rodz_Benef" order="ascending"/>
					<tr>
						<xsl:call-template name="TableCell">
							<xsl:with-param name="value" select="position()"/>
						</xsl:call-template>
						<xsl:call-template name="DynamicTableCell">
							<xsl:with-param name="dict" select="'KOD Płci'"/>
							<xsl:with-param name="code" select="Kod_Plci"/>
							<xsl:with-param name="class" select="'left'"/>
						</xsl:call-template>
						<xsl:call-template name="TableCell">
							<xsl:with-param name="value" select="Czy_Swiadczeniobiorca"/>
						</xsl:call-template>
						<xsl:call-template name="DynamicTableCell">
							<xsl:with-param name="dict" select="'KOD Rodzaju Beneficjenta'"/>
							<xsl:with-param name="code" select="Kod_Rodz_Benef"/>
							<xsl:with-param name="class" select="'left'"/>
						</xsl:call-template>
						<td>
							<button>
								<xsl:attribute name="onClick">
									currentParams.context = 'CzlonekRodziny';
									currentParams.contextParamNrSpraw = '<xsl:value-of select="$contextParamNrSpraw"/>';
									currentParams.contextParamIdOsoby = '<xsl:value-of select="Id_Osoby"/>';
									displayXML(currentParams);
								</xsl:attribute>
								<xsl:text>Pokaż</xsl:text>
							</button>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</fieldset>
	</xsl:template>
	<xsl:template name="CzlonekRodziny">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[Nr_Spr = $contextParamNrSpraw]/Czlonkowie_Rodz/Czlonek_Rodz[Id_Osoby = $contextParamIdOsoby]">
			<fieldset>
				<legend>Członek rodziny</legend>
				<table class="formTable">
					<tr>
						<td class="label">Płeć:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Płci'"/>
								<xsl:with-param name="code" select="Kod_Plci"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Rodzaj beneficjenta:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Beneficjenta'"/>
								<xsl:with-param name="code" select="Kod_Rodz_Benef"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Czy świadczeniobiorca:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Czy_Swiadczeniobiorca"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</fieldset>
			<br/>
			
			<xsl:call-template name="SytuacjaOsoby">
				<xsl:with-param name="idSytOsoby" select="Id_Syt_Osoby"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZrodlaFinansowania">
		<fieldset>
			<legend>Źródła finansowania</legend>
			<table border="1" width="100%">
				<tr>
					<th style="width: 10%;">Lp.</th>
					<th style="width: 24%;">Źródło</th>
					<th style="width: 22%;">Wartość miesiąc 1</th>
					<th style="width: 22%;">Wartość miesiąc 2</th>
					<th style="width: 22%;">Wartość miesiąc 3</th>
					<th style="width: 0%;">&#160;</th>
				</tr>
				
				<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[Nr_Spr = $contextParamNrSpraw]/Zrodla/Zrodlo">
					<xsl:sort select="Kod" order="ascending"/>
					<tr>
						<xsl:call-template name="TableCell">
							<xsl:with-param name="value" select="position()"/>
						</xsl:call-template>
						<xsl:call-template name="DynamicTableCell">
							<xsl:with-param name="dict" select="'KOD Źródeł Finansowania'"/>
							<xsl:with-param name="code" select="Kod"/>
							<xsl:with-param name="class" select="'left'"/>
						</xsl:call-template>
						<xsl:call-template name="TableCell">
							<xsl:with-param name="value" select="Wartosc/Mies_1"/>
							<xsl:with-param name="class" select="'right'"/>
						</xsl:call-template>
						<xsl:call-template name="TableCell">
							<xsl:with-param name="value" select="Wartosc/Mies_2"/>
							<xsl:with-param name="class" select="'right'"/>
						</xsl:call-template>
						<xsl:call-template name="TableCell">
							<xsl:with-param name="value" select="Wartosc/Mies_3"/>
							<xsl:with-param name="class" select="'right'"/>
						</xsl:call-template>
						<td>
							<button>
								<xsl:attribute name="onClick">
									currentParams.context = 'ZrodloFinansowania';
									currentParams.contextParamNrSpraw = '<xsl:value-of select="$contextParamNrSpraw"/>';
									currentParams.contextParamKodZrFin = '<xsl:value-of select="Kod" />';
									displayXML(currentParams);
								</xsl:attribute>
								<xsl:text>Pokaż</xsl:text>
							</button>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</fieldset>
	</xsl:template>
	<xsl:template name="ZrodloFinansowania">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie[Nr_Spr = $contextParamNrSpraw]/Zrodla/Zrodlo[Kod = $contextParamKodZrFin]">
			<fieldset>
				<legend>Źródło finansowania</legend>
				<table class="formTable">
					<tr>
						<td class="label">Źródło finansowania:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Źródeł Finansowania'"/>
								<xsl:with-param name="code" select="Kod"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Miesiąc</th>
									<th style="width: 80%;">Wartość</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_1"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_2"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Wartosc/Mies_3"/>
										<xsl:with-param name="class" select="'right'"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</fieldset>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="SytuacjaRodziny">
		<xsl:param name="idSytRodz"/>
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Rodzin/Syt_Rodz[Id_Syt_Rodz = $idSytRodz]">
			<fieldset>
				<legend>Sytuacja rodziny</legend>
				<table class="formTable">
					<tr>
						<td class="right">Rodzaj opisu sytuacji:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Opisu Sytuacji'"/>
								<xsl:with-param name="code" select="Kod_Rodz_Opisu_Syt"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="right">Data opisu sytuacji:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Opisu_Syt"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="right">Wielkość rodziny:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Wielkosc"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="right">Skład rodziny:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Składu Rodziny'"/>
								<xsl:with-param name="code" select="Kod_Skladu"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>					
					<tr>
						<td class="right">Dochód na osobę:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Doch_Na_Os"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="right">Liczba hektarów:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="L_Hek_Prz"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="right">Klasa miejscowości:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Klasy Miejscowości'"/>
								<xsl:with-param name="code" select="Kod_Kl_Miej"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</fieldset>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="SytuacjaOsoby">
		<xsl:param name="idSytOsoby"/>
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Osob/Syt_Osoby[Id_Syt_Osoby = $idSytOsoby]">
			<fieldset>
				<legend>Sytuacja osoby</legend>
				<table class="formTable">
					<tr>
						<td class="label">Data urodzenia:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Data_Urodz"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Stan cywilnyo:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Stanu Cywilnego'"/>
								<xsl:with-param name="code" select="Kod_St_Cyw"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Rola w rodzinie:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Roli W Rodzinie'"/>
								<xsl:with-param name="code" select="Kod_Rol_Rodz"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Pokrewieństwo:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Stopnia Pokrewieństwa'"/>
								<xsl:with-param name="code" select="Kod_Pok_Z_Gl"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Rodzaj wykształcenia:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Rodzaju Wykształcenia'"/>
								<xsl:with-param name="code" select="Kod_Rodz_Wyk"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Pozycja na rynku pracy:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Pozycji Na Rynku Pracy'"/>
								<xsl:with-param name="code" select="Kod_Poz_Ryn_Pr"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="1px" class="innerTable">
								<tr>
									<th style="width: 20%;">Miesiąc</th>
									<th style="width: 40%;">Źródło dochodu</th>
									<th style="width: 40%;">Kwota</th>
								</tr>
								<tr>
									<td>1</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Źródła Dochodu'"/>
										<xsl:with-param name="code" select="Dochody/Zrod_1"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Dochody/Kw_Mies_1"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>2</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Źródła Dochodu'"/>
										<xsl:with-param name="code" select="Dochody/Zrod_2"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Dochody/Kw_Mies_2"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>3</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Źródła Dochodu'"/>
										<xsl:with-param name="code" select="Dochody/Zrod_3"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Dochody/Kw_Mies_3"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>4</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Źródła Dochodu'"/>
										<xsl:with-param name="code" select="Dochody/Zrod_4"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Dochody/Kw_Mies_4"/>
									</xsl:call-template>
								</tr>
								<tr>
									<td>5</td>
									<xsl:call-template name="DynamicTableCell">
										<xsl:with-param name="dict" select="'KOD Rodzaju Źródła Dochodu'"/>
										<xsl:with-param name="code" select="Dochody/Zrod_5"/>
									</xsl:call-template>
									<xsl:call-template name="TableCell">
										<xsl:with-param name="value" select="Dochody/Kw_Mies_5"/>
									</xsl:call-template>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="label">Stan zdrowia:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Stanu Zdrowia'"/>
								<xsl:with-param name="code" select="Kod_Stanu_Zdr"/>
								<xsl:with-param name="class" select="'medium'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Czy niepełnosprawność:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Czy_Niepelnosp"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Czy grupa inwalidzka:</td>
						<td class="left">
							<xsl:call-template name="Input">
								<xsl:with-param name="value" select="Czy_Ust_Gr_Inw"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td class="label">Orzeczenie o niepełnosprawności:</td>
						<td class="left">
							<xsl:call-template name="DynamicInput">
								<xsl:with-param name="dict" select="'KOD Orzeczenia O Niepełnospra'"/>
								<xsl:with-param name="code" select="Kod_Orz_O_Niep"/>
								<xsl:with-param name="class" select="'long'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</fieldset>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="TableHeader">
		<xsl:param name="total"/>
		<div class="tableHeader">
			<table>
				<tr>
					<td>
						<button>
							<xsl:attribute name="onClick">
								currentParams.page = 1;
								displayXML(currentParams);
							</xsl:attribute>
							<xsl:text>&lt;&lt;</xsl:text>
						</button>
					</td>
					<td>
						<button>
							<xsl:attribute name="onClick">
								if (currentParams.page > 1) {
									currentParams.page = currentParams.page - 1;
								}
								displayXML(currentParams);
							</xsl:attribute>
							<xsl:text>&lt;</xsl:text>
						</button>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="$total = 0">0</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="($page - 1) * $pageSize + 1"/>
							</xsl:otherwise>
						</xsl:choose> - <xsl:choose>
							<xsl:when test="$page * $pageSize > $total">
								<xsl:value-of select="$total"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$page * $pageSize"/>
							</xsl:otherwise>
						</xsl:choose> / <xsl:value-of select="$total"/>
					</td>
					<td>
						<button>
							<xsl:attribute name="onClick">
								var totalPages = Math.ceil(<xsl:value-of select="$total"/> / <xsl:value-of select="$pageSize"/>);
								if (currentParams.page &lt; totalPages) {
									currentParams.page = currentParams.page + 1;
								}
								displayXML(currentParams);
							</xsl:attribute>
							<xsl:text>&gt;</xsl:text>
						</button>
					</td>
					<td>
						<button>
							<xsl:attribute name="onClick">
								var totalPages = Math.ceil(<xsl:value-of select="$total"/> / <xsl:value-of select="$pageSize"/>);
								currentParams.page = totalPages;
								displayXML(currentParams);
							</xsl:attribute>
							<xsl:text>&gt;&gt;</xsl:text>
						</button>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>
	<xsl:template name="TableCell">
		<xsl:param name="value"/>
		<xsl:param name="class"/>
		<td>
			<xsl:attribute name="class">
				<xsl:value-of select="$class"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$value != ''">
					<xsl:value-of select="$value"/>
				</xsl:when>
				<xsl:otherwise>
					<br/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<xsl:template name="DynamicTableCell">
		<xsl:param name="dict"/>
		<xsl:param name="code"/>
		<xsl:param name="class"/>
		<td>
			<xsl:attribute name="class">
				<xsl:value-of select="$class"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$code != ''">
					<div>
						<xsl:attribute name="id">
							<xsl:value-of select="concat($dict, '_', $code, '_', position())"/>
						</xsl:attribute>
					</div>
					<script>
						var dict = '<xsl:value-of select="$dict"/>';
						var code = '<xsl:value-of select="$code"/>';
						var divId = '<xsl:value-of select="concat($dict, '_', $code, '_', position())"/>';
						if (SL != undefined) {
							if (SL[dict] != undefined) {
								if (SL[dict][code] != undefined) {
									code = SL[dict][code].opis + ' (' + code + ')';
								}
							}
							if (dict == 'KOD Rodzaju Świadczenia') {
								// kody swiadczen sprawdzane w slownikow kodow swiadczen pozaustawowych
								var dict2 = 'KOD Świadczenia Pozaustawowego';
								if (SL[dict2] != undefined) {
									if (SL[dict2][code] != undefined) {
										code = SL[dict2][code].opis + ' (' + code + ')';
									}
								}
							}
						}
						
						var outputDiv = output.getElementById(divId);
						outputDiv.innerHTML = code;
					</script>
				</xsl:when>
				<xsl:otherwise>
					<br/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<xsl:template name="Input">
		<xsl:param name="value"/>
		<xsl:param name="class" select="'disabled'"/>
		<input type="text" class="disabled" readonly="readonly">
			<xsl:attribute name="value">
				<xsl:value-of select="$value"/>
			</xsl:attribute>
		</input>
	</xsl:template>
	<xsl:template name="DynamicInput">
		<xsl:param name="dict"/>
		<xsl:param name="code"/>
		<xsl:param name="class" select="'disabled'"/>
		<xsl:choose>
			<xsl:when test="$class = 'long'">
				<textarea rows="2" cols="20" class="disabled" readonly="readonly">
					<xsl:attribute name="id">
						<xsl:value-of select="concat($dict, '_', $code, '_', position())"/>
					</xsl:attribute>
					.
				</textarea>
				<script>
					var dict = '<xsl:value-of select="$dict"/>';
					var code = '<xsl:value-of select="$code"/>';
					var divId = '<xsl:value-of select="concat($dict, '_', $code, '_', position())"/>';
					if (SL != undefined) {
						if (SL[dict] != undefined) {
							if (SL[dict][code] != undefined) {
								code = SL[dict][code].opis;
							}
						}
						if (dict == 'KOD Rodzaju Świadczenia') {
							// kody swiadczen sprawdzane w slownikow kodow swiadczen pozaustawowych
							var dict2 = 'KOD Świadczenia Pozaustawowego';
							if (SL[dict2] != undefined) {
								if (SL[dict2][code] != undefined) {
									code = SL[dict2][code].opis;
								}
							}
						}
					}
					
					var outputDiv = output.getElementById(divId);
					outputDiv.innerHTML = code;
				</script>
			</xsl:when>
			<xsl:otherwise>
				<input type="text" class="disabled" readonly="readonly">
					<xsl:attribute name="id">
						<xsl:value-of select="concat($dict, '_', $code, '_', position())"/>
					</xsl:attribute>
					<xsl:attribute name="class">
						<xsl:value-of select="$class"/>
					</xsl:attribute>
				</input>
				<script>
					var dict = '<xsl:value-of select="$dict"/>';
					var code = '<xsl:value-of select="$code"/>';
					var divId = '<xsl:value-of select="concat($dict, '_', $code, '_', position())"/>';
					if (SL != undefined) {
						if (SL[dict] != undefined) {
							if (SL[dict][code] != undefined) {
								code = SL[dict][code].opis;
							}
						}
						if (dict == 'KOD Rodzaju Świadczenia') {
							// kody swiadczen sprawdzane w slownikow kodow swiadczen pozaustawowych
							var dict2 = 'KOD Świadczenia Pozaustawowego';
							if (SL[dict2] != undefined) {
								if (SL[dict2][code] != undefined) {
									code = SL[dict2][code].opis;
								}
							}
						}
					}
					
					var outputDiv = output.getElementById(divId);
					outputDiv.value = code;
				</script>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c) 2004-2008. Progress Software Corporation. All rights reserved.

<metaInformation>
	<scenarios/>
	<MapperMetaTag>
		<MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
		<MapperBlockPosition></MapperBlockPosition>
		<TemplateContext></TemplateContext>
		<MapperFilter side="source"></MapperFilter>
	</MapperMetaTag>
</metaInformation>
-->