package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W10Validator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	@Override
	public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
		LocalDate dataUrodzenia = target.getDataUrodzenia();
		if (dataUrodzenia == null) {
			errors.rejectValue("dataUrodzenia", "W10", "Data urodzenia nie powinna być pusta");
			return;
		}
		LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) {
			return;
		}
		//
		if (ChronoUnit.DAYS.between(dataUrodzenia, dataOpisuSytuacji) < 0) {
			errors.rejectValue("dataUrodzenia", "W10", "Data urodzenia jest późniejsza niż data opisu sytuacji.");
		}
		if (ChronoUnit.YEARS.between(dataUrodzenia, dataOpisuSytuacji) > 125) {
			errors.rejectValue("dataUrodzenia", "W10", "Data urodzenia jest niepoprawna.");
		}
	}
}
