package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.Kody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W20aValidator1 implements ComplexValidator<SytuacjaRodziny, SwiadczenieSprawozdawcze> {
	private static final ImmutableSet<String> WYLACZONE = ImmutableSet.of(
		"111000", "115000", "118000", "140", "206000", "207", "208", "209x",
		"214", "214x", "214y", "217000", "320", "408", "409x", "4302",
		"202040", "202050",
		"190051"
	);
	
	@Override
	public void validate(SytuacjaRodziny target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		LocalDate dataOpisuSytuacji = target.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return;
		String kodSwiadczenia = context.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		List<YearMonth> przyslugujeZa = context.getPrzyslugujeZa();
		if (przyslugujeZa == null) return;
		//
		if (Kody.prefiksy(kodSwiadczenia).anyMatch(WYLACZONE::contains)) return;
		if (przyslugujeZa.isEmpty()) return;
		//
		YearMonth ostatniMiesiac = Collections.max(przyslugujeZa);
		if (dataOpisuSytuacji.isBefore(ostatniMiesiac.atDay(1).minusMonths(6))) {
			errors.rejectValue("dataOpisuSytuacji", "W20a", "Data opisu sytuacji nie może być wcześniejsza niż data wcześniejsza o pół roku od pierwszego dnia najpóżniejszego miesiąca, za który przysługuje świadczenie");
		}
	}
}
