package pl.gov.mpips.zbc.v20090722;

import java.util.List;

import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W22Validator2SS implements SimpleValidator<SwiadczenieSprawozdawcze> {
	@Override
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		SytuacjaRodziny sytuacjaRodziny = target.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return;
		List<CzlonekRodziny> czlonkowieRodziny = target.getCzlonkowieRodziny();
		if (czlonkowieRodziny == null) return;
		//
		for (int i = 0; i < czlonkowieRodziny.size(); i++) {
			CzlonekRodziny czlonekRodziny = czlonkowieRodziny.get(i);
			boolean wskazanoOsobe = czlonekRodziny.getIdOsoby() != null;
			boolean wskazanoSytuacjeOsoby = czlonekRodziny.getSytuacjaOsoby() != null;
			if (wskazanoOsobe && !wskazanoSytuacjeOsoby) {
				errors.rejectValue("czlonkowieRodziny.sytuacjaOsoby" + (i + 1), "W22", "Wskazanie sytuacji osoby jest wymagane");
			}
		}
	}
}
