package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;

import org.threeten.extra.YearQuarter;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSortedMap;

import pl.topteam.common.collect.ExtraMaps;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W23Validator implements SimpleValidator<ZbiorCentralny> {
	private static final ImmutableRangeMap<LocalDate, Integer> DYSTRYBUCJE_SLOWNIKOW = ExtraMaps.toImmutableRangeMap(ImmutableSortedMap.of(
		LocalDate.parse("2016-10-03"), 63,
		LocalDate.parse("2018-09-24"), 64,
		LocalDate.parse("2018-11-14"), 65,
		LocalDate.parse("2019-01-08"), 66,
		LocalDate.parse("2019-05-08"), 67
	));

	@Override
	public void validate(ZbiorCentralny target, BasicErrors errors) {
		YearQuarter okres = target.getOkres();
		if (okres == null) return;
		Integer numerZestawuSlownikow = target.getNumerZestawuSlownikow();
		if (numerZestawuSlownikow == null) return;
		Integer dystrybucjaSlownikow = DYSTRYBUCJE_SLOWNIKOW.get(okres.atDay(1).minusDays(1));
		if (dystrybucjaSlownikow == null) return;
		if (numerZestawuSlownikow < dystrybucjaSlownikow) {
			errors.rejectValue("numerZestawuSlownikow", "W23", ""
				+ "Numer zestawu słowników nie może być niższy "
				+ "niż numer ostatniego zestawu wydystrybuowanego "
				+ "przed pierwszym dniem okresu za który przesyłany jest zbiór"
			);
		}
	}
}
