package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.Kody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W27Validator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final ImmutableSet<String> GRUPY = ImmutableSet.of(
		"102", "112", "117", "130", "212", "213", "215", "216", "202", "203",
		"204", "205", "210", "211", "221", "318", "330", "416", "417", "430",
		"290"
	);
	private static final ImmutableSet<String> WYJATKI = ImmutableSet.of(
		"202030", "202040", "202050", "318050", "290504"
	);
	
	@Override
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		if (!uzupelnionaSytuacjaRodziny(target) && sytuacjaRodzinyJestWymagana(target)) {
			errors.rejectValue("sytuacjaRodziny", "W27", "Uzupełnienie sytuacji rodziny jest wymagane");
		}
	}
	
	private boolean uzupelnionaSytuacjaRodziny(SwiadczenieSprawozdawcze swiadczenie) {
		SytuacjaRodziny sytuacjaRodziny = swiadczenie.getSytuacjaRodziny();
		return sytuacjaRodziny != null;
	}
	
	private boolean sytuacjaRodzinyJestWymagana(SwiadczenieSprawozdawcze swiadczenie) {
		String kodSwiadczenia = swiadczenie.getKodSwiadczenia();
		if (kodSwiadczenia == null) return false; // brak danych
		return Kody.prefiksy(kodSwiadczenia).anyMatch(GRUPY::contains) && !WYJATKI.contains(kodSwiadczenia);
	}
}
