package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20090722.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W35Validator implements ComplexValidator<SytuacjaRodziny, SwiadczenieSprawozdawcze> {
	private static final ImmutableSet<String> PROBLEM_WIELODZIETNOSCI = ImmutableSet.of(
		"043", "082"
	);
	private static final ImmutableSet<String> POTENCJALNA_WIELODZIETNOSC = ImmutableSet.of(
		"123", "124", "125", "126", "127", "133", "134", "137", "138", "153", "154", "155", "156", "157",
		"211", "219", "221", "229", "230", "320", "400"
	);
	
	@Override
	public void validate(SytuacjaRodziny target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		if (wskazanoProblemWielodzietnosci(context) && !kodSkladuRodzinyDopuszczaWielodzietnosc(target)) {
			errors.rejectValue("kodSkladuRodziny", "W35",
				"Wartość kodu składu rodziny jest niezgodna z jednym z kodów rodzaju problemu wskazanym w świadczeniu (wielodzietność)");
		}
		
	}
	
	private boolean wskazanoProblemWielodzietnosci(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
		Problemy problemy = swiadczenieSprawozdawcze.getProblemy();
		if (problemy == null) return false;
		return Listy.kody(problemy).stream().anyMatch(PROBLEM_WIELODZIETNOSCI::contains);
	}
	
	private boolean kodSkladuRodzinyDopuszczaWielodzietnosc(SytuacjaRodziny sytuacjaRodziny) {
		String kodSkladuRodziny = sytuacjaRodziny.getKodSkladuRodziny();
		return POTENCJALNA_WIELODZIETNOSC.contains(kodSkladuRodziny);
	}
}
