package pl.gov.mpips.zbc.v20090722;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby.Dochody;

public class ZbiorCentralnyValidator implements Validator {
	private final W01ValidatorSO W01ValidatorSO = new W01ValidatorSO();
	private final W01ValidatorSR W01ValidatorSR = new W01ValidatorSR();
	private final W02Validator W02Validator = new W02Validator();
	private final W03aValidator W03aValidator = new W03aValidator();
	private final W03Validator W03Validator = new W03Validator();
	private final W04Validator W04Validator = new W04Validator();
	private final W05aValidator W05aValidator = new W05aValidator();
	private final W05Validator W05Validator = new W05Validator();
	private final W06Validator W06Validator = new W06Validator();
	private final W07Validator W07Validator = new W07Validator();
	private final W08Validator W08Validator = new W08Validator();
	private final W09aValidator W09aValidator = new W09aValidator();
	private final W09Validator W09Validator = new W09Validator();
	private final W10Validator W10Validator = new W10Validator();
	private final W11Validator W11Validator = new W11Validator();
	private final W12Validator W12Validator = new W12Validator();
	private final W13Validator W13Validator = new W13Validator();
	private final W14Validator W14Validator = new W14Validator();
	private final W14aValidator W14aValidator = new W14aValidator();
	private final W15Validator W15Validator = new W15Validator();
	private final W16Validator W16Validator = new W16Validator();
	private final W17Validator W17Validator = new W17Validator();
	private final W18Validator W18Validator = new W18Validator();
	private final W19Validator W19Validator = new W19Validator();
	private final W20Validator W20Validator = new W20Validator();
	private final W20ValidatorSDO W20ValidatorSDO = new W20ValidatorSDO();
	private final W20ValidatorWS W20ValidatorWS = new W20ValidatorWS();
	private final W20aValidator1 W20aValidator1 = new W20aValidator1();
	private final W20aValidator2 W20aValidator2 = new W20aValidator2();
	private final W21Validator W21Validator = new W21Validator();
	private final W22Validator1 W22Validator1 = new W22Validator1();
	private final W22Validator2SDO W22Validator2SDO = new W22Validator2SDO();
	private final W22Validator2SS W22Validator2SS = new W22Validator2SS();
	private final W22Validator2WS W22Validator2WS = new W22Validator2WS();
	private final W23Validator W23Validator = new W23Validator();
	private final W24Validator W24Validator = new W24Validator();
	private final W25Validator W25Validator = new W25Validator();
	private final W26ValidatorSDO W26ValidatorSDO = new W26ValidatorSDO();
	private final W26ValidatorSS W26ValidatorSS = new W26ValidatorSS();
	private final W26ValidatorWS W26ValidatorWS = new W26ValidatorWS();
	private final W27Validator W27Validator = new W27Validator();
	private final W28Validator W28Validator = new W28Validator();
	private final W29Validator W29Validator = new W29Validator();
	private final W30Validator W30Validator = new W30Validator();
	private final W31Validator W31Validator = new W31Validator();
	private final W32Validator W32Validator = new W32Validator();
	private final W33Validator W33Validator = new W33Validator();
	private final W34Validator W34Validator = new W34Validator();
	private final W35Validator W35Validator = new W35Validator();
	private final W36Validator W36Validator = new W36Validator();
	private final W37Validator W37Validator = new W37Validator();
	
	@Override
	public boolean supports(Class<?> clazz) {
		return clazz.equals(ZbiorCentralny.class);
	}
	
	@Override
	public void validate(Object target, Errors errors) {
		ZbiorCentralny zbiorCentralny = (ZbiorCentralny) target;
		if (zbiorCentralny != null) {
			W23Validator.validate(zbiorCentralny, errors::rejectValue);
			W37Validator.validate(zbiorCentralny, errors::rejectValue);
			if (zbiorCentralny.getDecyzjeOdmowne() != null) {
				for (int d = 0; d < zbiorCentralny.getDecyzjeOdmowne().size(); d++) {
					SprawozdawczaDecyzjaOdmowna decyzjaOdmowna = zbiorCentralny.getDecyzjeOdmowne().get(d);
					if (decyzjaOdmowna != null) {
						errors.pushNestedPath("decyzjeOdmowne[" + d + "]");
						W22Validator2SDO.validate(decyzjaOdmowna, errors::rejectValue);
						W26ValidatorSDO.validate(decyzjaOdmowna, errors::rejectValue);
						W14Validator.validate(decyzjaOdmowna, errors::rejectValue);
						W14aValidator.validate(decyzjaOdmowna, errors::rejectValue);
						W20ValidatorSDO.validate(decyzjaOdmowna, zbiorCentralny, errors::rejectValue);
						SytuacjaRodziny sytuacjaRodziny = decyzjaOdmowna.getSytuacjaRodziny();
						if (sytuacjaRodziny != null) {
							errors.pushNestedPath("sytuacjaRodziny");
							W01ValidatorSR.validate(sytuacjaRodziny, errors::rejectValue);
							W02Validator.validate(sytuacjaRodziny, errors::rejectValue);
							errors.popNestedPath();
						}
						SytuacjaOsoby sytuacjaOsoby = decyzjaOdmowna.getSytuacjaOsoby();
						if (sytuacjaOsoby != null) {
							errors.pushNestedPath("sytuacjaOsoby");
							W05aValidator.validate(sytuacjaOsoby, errors::rejectValue);
							W07Validator.validate(sytuacjaOsoby, errors::rejectValue);
							W08Validator.validate(sytuacjaOsoby, errors::rejectValue);
							W33Validator.validate(sytuacjaOsoby, errors::rejectValue);
							W34Validator.validate(sytuacjaOsoby, errors::rejectValue);
							if (sytuacjaRodziny != null) {
								W01ValidatorSO.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W03aValidator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W06Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W10Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W15Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W16Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W17Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W18Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W36Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
							}
							Dochody dochody = sytuacjaOsoby.getDochody();
							if (dochody != null) {
								errors.pushNestedPath("dochody");
								W03Validator.validate(dochody, errors::rejectValue);
								errors.popNestedPath();
							}
							errors.popNestedPath();
						}
						errors.popNestedPath();
					}
				}
			}
			if (zbiorCentralny.getSwiadczenia() != null) {
				for (int s = 0; s < zbiorCentralny.getSwiadczenia().size(); s++) {
					SwiadczenieSprawozdawcze swiadczenie = zbiorCentralny.getSwiadczenia().get(s);
					if (swiadczenie != null) {
						errors.pushNestedPath("swiadczenia[" + s + "]");
						W09aValidator.validate(swiadczenie, errors::rejectValue);
						W09Validator.validate(swiadczenie, errors::rejectValue);
						W22Validator1.validate(swiadczenie, errors::rejectValue);
						W22Validator2SS.validate(swiadczenie, errors::rejectValue);
						W25Validator.validate(swiadczenie, errors::rejectValue);
						W26ValidatorSS.validate(swiadczenie, errors::rejectValue);
						W27Validator.validate(swiadczenie, errors::rejectValue);
						W28Validator.validate(swiadczenie, errors::rejectValue);
						W29Validator.validate(swiadczenie, errors::rejectValue);
						W30Validator.validate(swiadczenie, errors::rejectValue);
						W31Validator.validate(swiadczenie, errors::rejectValue);
						W32Validator.validate(swiadczenie, errors::rejectValue);
						W19Validator.validate(swiadczenie, zbiorCentralny, errors::rejectValue);
						W20Validator.validate(swiadczenie, zbiorCentralny, errors::rejectValue);
						W20aValidator2.validate(swiadczenie, zbiorCentralny, errors::rejectValue);
						SytuacjaRodziny sytuacjaRodziny = swiadczenie.getSytuacjaRodziny();
						if (sytuacjaRodziny != null) {
							errors.pushNestedPath("sytuacjaRodziny");
							W01ValidatorSR.validate(sytuacjaRodziny, errors::rejectValue);
							W02Validator.validate(sytuacjaRodziny, errors::rejectValue);
							W20aValidator1.validate(sytuacjaRodziny, swiadczenie, errors::rejectValue);
							W35Validator.validate(sytuacjaRodziny, swiadczenie, errors::rejectValue);
							errors.popNestedPath();
						}
						LiczbaSwiadczen liczba = swiadczenie.getLiczba();
						if (liczba != null) {
							errors.pushNestedPath("liczba");
							W24Validator.validate(liczba, errors::rejectValue);
							errors.popNestedPath();
						}
						Problemy problemy = swiadczenie.getProblemy();
						if (problemy != null) {
							errors.pushNestedPath("problemy");
							W11Validator.validate(problemy, swiadczenie, errors::rejectValue);
							W12Validator.validate(problemy, swiadczenie, errors::rejectValue);
							W13Validator.validate(problemy, swiadczenie, errors::rejectValue);
							W21Validator.validate(problemy, swiadczenie, errors::rejectValue);
							errors.popNestedPath();
						}
						if (swiadczenie.getCzlonkowieRodziny() != null) {
							for (int c = 0; c < swiadczenie.getCzlonkowieRodziny().size(); c++) {
								CzlonekRodziny czlonekRodziny = swiadczenie.getCzlonkowieRodziny().get(c);
								if (czlonekRodziny != null) {
									errors.pushNestedPath("czlonkowieRodziny[" + c + "]");
									SytuacjaOsoby sytuacjaOsoby = czlonekRodziny.getSytuacjaOsoby();
									if (sytuacjaOsoby != null) {
										errors.pushNestedPath("sytuacjaOsoby");
										W05aValidator.validate(sytuacjaOsoby, errors::rejectValue);
										W07Validator.validate(sytuacjaOsoby, errors::rejectValue);
										W08Validator.validate(sytuacjaOsoby, errors::rejectValue);
										W33Validator.validate(sytuacjaOsoby, errors::rejectValue);
										W34Validator.validate(sytuacjaOsoby, errors::rejectValue);
										W04Validator.validate(sytuacjaOsoby, czlonekRodziny, errors::rejectValue);
										W05Validator.validate(sytuacjaOsoby, czlonekRodziny, errors::rejectValue);
										if (sytuacjaRodziny != null) {
											W01ValidatorSO.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W03aValidator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W06Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W10Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W15Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W16Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W17Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W18Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
											W36Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
										}
										Dochody dochody = sytuacjaOsoby.getDochody();
										if (dochody != null) {
											errors.pushNestedPath("dochody");
											W03Validator.validate(dochody, errors::rejectValue);
											errors.popNestedPath();
										}
										errors.popNestedPath();
									}
									errors.popNestedPath();
								}
							}
						}
						errors.popNestedPath();
					}
				}
			}
			if (zbiorCentralny.getWnioski() != null) {
				for (int w = 0; w < zbiorCentralny.getWnioski().size(); w++) {
					WniosekSprawozdawczy wniosek = zbiorCentralny.getWnioski().get(w);
					if (wniosek != null) {
						errors.pushNestedPath("wnioski[" + w + "]");
						W22Validator2WS.validate(wniosek, errors::rejectValue);
						W26ValidatorWS.validate(wniosek, errors::rejectValue);
						W20ValidatorWS.validate(wniosek, zbiorCentralny, errors::rejectValue);
						SytuacjaRodziny sytuacjaRodziny = wniosek.getSytuacjaRodziny();
						if (sytuacjaRodziny != null) {
							errors.pushNestedPath("sytuacjaRodziny");
							W01ValidatorSR.validate(sytuacjaRodziny, errors::rejectValue);
							W02Validator.validate(sytuacjaRodziny, errors::rejectValue);
							errors.popNestedPath();
						}
						SytuacjaOsoby sytuacjaOsoby = wniosek.getSytuacjaOsoby();
						if (sytuacjaOsoby != null) {
							errors.pushNestedPath("sytuacjaOsoby");
							W05aValidator.validate(sytuacjaOsoby, errors::rejectValue);
							W07Validator.validate(sytuacjaOsoby, errors::rejectValue);
							W08Validator.validate(sytuacjaOsoby, errors::rejectValue);
							W33Validator.validate(sytuacjaOsoby, errors::rejectValue);
							W34Validator.validate(sytuacjaOsoby, errors::rejectValue);
							if (sytuacjaRodziny != null) {
								W01ValidatorSO.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W03aValidator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W06Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W10Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W15Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W16Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W17Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W18Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
								W36Validator.validate(sytuacjaOsoby, sytuacjaRodziny, errors::rejectValue);
							}
							Dochody dochody = sytuacjaOsoby.getDochody();
							if (dochody != null) {
								errors.pushNestedPath("dochody");
								W03Validator.validate(dochody, errors::rejectValue);
								errors.popNestedPath();
							}
							errors.popNestedPath();
						}
						errors.popNestedPath();
					}
				}
			}
			if (zbiorCentralny.getWydatkiSrodkow() != null) {
				for (int w = 0; w < zbiorCentralny.getWydatkiSrodkow().size(); w++) {
					errors.pushNestedPath("wydatkiSrodkow[" + w + "]");
					SprawozdawczyWydatekSrodkow sprawozdawczyWydatekSrodkow = zbiorCentralny.getWydatkiSrodkow().get(w);
					errors.pushNestedPath("liczba");
					LiczbaSwiadczen liczba = sprawozdawczyWydatekSrodkow.getLiczba();
					if (liczba != null) {
						W24Validator.validate(liczba, errors::rejectValue);
					}
					errors.popNestedPath();
					errors.popNestedPath();
				}
			}
		}
	}
}
