package pl.gov.mpips.zbc.v20200306;

import static com.google.common.collect.Range.atLeast;
import static com.google.common.collect.Range.singleton;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W02Validator implements SimpleValidator<SytuacjaRodziny> {
	private static final Map<String, Range<Integer>> WIELKOSC = ImmutableMap.<String, Range<Integer>>builder()
		.put("110", singleton(2))
		.put("121", singleton(3))
		.put("122", singleton(4))
		.put("123", singleton(5))
		.put("124", singleton(6))
		.put("125", singleton(7))
		.put("126", singleton(8))
		.put("127", atLeast(9))
		.put("131", singleton(2))
		.put("132", singleton(3))
		.put("133", singleton(4))
		.put("134", atLeast(5))
		.put("135", singleton(2))
		.put("136", singleton(3))
		.put("137", singleton(4))
		.put("138", atLeast(5))
		.put("140", singleton(2))
		.put("151", singleton(3))
		.put("152", singleton(4))
		.put("153", singleton(5))
		.put("154", singleton(6))
		.put("155", singleton(7))
		.put("156", singleton(8))
		.put("157", atLeast(9))
		.put("211", atLeast(2))
		.put("219", atLeast(2))
		.put("221", atLeast(3))
		.put("229", atLeast(3))
		.put("230", atLeast(4))
		.put("310", singleton(1))
		.put("320", atLeast(2))
		.build();
	
	@Override
	public void validate(SytuacjaRodziny target, BasicErrors errors) {
		String kodSkladuRodziny = target.getKodSkladuRodziny();
		Integer wielkosc = target.getWielkosc();
		Range<Integer> zakres = WIELKOSC.get(kodSkladuRodziny);
		if (zakres != null && wielkosc != null && !zakres.contains(wielkosc)) {
			errors.rejectValue("wielkosc", "W02", "Wielkość rodziny niezgodna z kodem składu rodziny");
		}
	}
}
