package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W04Validator implements ComplexValidator<SytuacjaOsoby, CzlonekRodziny> {
	private static final ImmutableSetMultimap<String, String> STANY_CYWILNE = ImmutableSetMultimap.<String, String>builder()
		.putAll("1", ImmutableList.of("01", "03", "05", "07", "09", "11"))
		.putAll("2", ImmutableList.of("02", "04", "06", "08", "10", "12"))
		.build();
	
	@Override
	public void validate(SytuacjaOsoby target, CzlonekRodziny context, BasicErrors errors) {
		String kodPlci = context.getKodPlci();
		String kodStanuCywilnego = target.getKodStanuCywilnego();
		if (kodPlci == null || kodStanuCywilnego == null) return;
		if (STANY_CYWILNE.containsKey(kodPlci) && !STANY_CYWILNE.get(kodPlci).contains(kodStanuCywilnego)) {
			errors.rejectValue("kodStanuCywilnego", "W04", "Wartość kodu stanu cywilnego jest niezgodna z kodem płci");
		}
	}
}
