package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W05Validator implements ComplexValidator<SytuacjaOsoby, CzlonekRodziny> {
	private static final ImmutableSetMultimap<String, String> BLEDNE_PARY = ImmutableSetMultimap.<String, String>builder()
		.putAll("1", ImmutableList.of("02", "04", "06", "08", "10", "12", "14", "16", "18", "20", "22", "27"))
		.putAll("2", ImmutableList.of("01", "03", "05", "07", "09", "11", "13", "15", "17", "19", "21", "26"))
		.build();
	
	@Override
	public void validate(SytuacjaOsoby target, CzlonekRodziny context, BasicErrors errors) {
		String kodPokrewienstwaZGlowaRodziny = target.getKodPokrewienstwaZGlowaRodziny();
		String kodPlci = context.getKodPlci();
		if (BLEDNE_PARY.get(kodPlci).contains(kodPokrewienstwaZGlowaRodziny)) {
			errors.rejectValue("kodStanuCywilnego", "W05", "Wartość kodu pokrewieństwa z głową rodziny jest niezgodna z kodem płci");
		}
	}
}
