package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W09aValidator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	@Override
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		if (weryfikowalne(target)) {
			if (!poprawne(target)) {
				errors.rejectValue(null, "W09a", "Niepoprawne wartości Kodu roli w rodzinie, Kodu płci, Kodu stopnia pokrewieństwa i Kodu stanu cywilnego w ramach jednej sytuacji rodziny");
			}
		}
	}
	
	private boolean weryfikowalne(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
		List<CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
		if (czlonkowieRodziny == null) return false; // ??
		if (czlonkowieRodziny.stream().map(CzlonekRodziny::getSytuacjaOsoby).anyMatch(Objects::isNull)) return false; // ??
		return true;
	}
	
	private boolean poprawne(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
		List<CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
		int mezczyznaGlowa = (int) czlonkowieRodziny.stream().filter(MEZCZYZNA.and(GLOWA).and(POKREWIENSTWO_NIEOKRESLONE)).count();
		int kobietaGlowa = (int) czlonkowieRodziny.stream().filter(KOBIETA.and(GLOWA).and(POKREWIENSTWO_NIEOKRESLONE)).count();
		int mazCzlonek = (int) czlonkowieRodziny.stream().filter(MEZCZYZNA.and(CZLONEK).and(ZONATY).and(MAZ)).count();
		int zonaCzlonek = (int) czlonkowieRodziny.stream().filter(KOBIETA.and(CZLONEK).and(ZAMEZNA).and(ZONA)).count();
		if (mezczyznaGlowa == 1) {
			return kobietaGlowa == 0 && mazCzlonek == 0 && zonaCzlonek < 2;
		}
		if (kobietaGlowa == 1) {
			return mezczyznaGlowa == 0 && zonaCzlonek == 0 && mazCzlonek < 2;
		}
		return true;
	}
	
	// predykaty słownikowe
	
	private Predicate<CzlonekRodziny> plec(String kod) {
		return czlonekRodziny -> kod.equals(czlonekRodziny.getKodPlci());
	}
	
	private Predicate<CzlonekRodziny> stanCywilny(String kod) {
		return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodStanuCywilnego());
	}
	
	private Predicate<CzlonekRodziny> stopienPokrewienstwa(String kod) {
		return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodPokrewienstwaZGlowaRodziny());
	}
	
	private Predicate<CzlonekRodziny> kodRoliWRodzinie(String kod) {
		return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodRoliWRodzinie());
	}
	
	// predykaty słownikowe c.d.
	
	private Predicate<CzlonekRodziny> MEZCZYZNA = plec("1");
	private Predicate<CzlonekRodziny> KOBIETA = plec("2");
	
	private Predicate<CzlonekRodziny> ZONATY = stanCywilny("03");
	private Predicate<CzlonekRodziny> ZAMEZNA = stanCywilny("04");
	
	private Predicate<CzlonekRodziny> MAZ = stopienPokrewienstwa("15");
	private Predicate<CzlonekRodziny> ZONA = stopienPokrewienstwa("16");
	
	private Predicate<CzlonekRodziny> POKREWIENSTWO_NIEOKRESLONE = stopienPokrewienstwa("98");
	
	private Predicate<CzlonekRodziny> GLOWA = kodRoliWRodzinie("1");
	private Predicate<CzlonekRodziny> CZLONEK = GLOWA.negate();
}
