package pl.gov.mpips.zbc.v20200306;

import java.time.LocalDate;

import com.google.common.collect.ImmutableSet;

import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W17Validator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	@Override
	public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
		if (zaWczesnieNaSlub(sytuacjaOsoby, context) && !kawalerLubPanna(sytuacjaOsoby)) {
			errors.rejectValue("kodStanuCywilnego", "W17", "U osób młodszych niż 16 lat dozwolonymi wartościami są kawaler i panna");
		}
	}
	
	private boolean zaWczesnieNaSlub(SytuacjaOsoby target, SytuacjaRodziny context) {
		LocalDate dataUrodzenia = target.getDataUrodzenia();
		if (dataUrodzenia == null) return false;
		LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return false;
		//
		return ExtraChronoUnit.LEGAL_YEARS.between(dataUrodzenia, dataOpisuSytuacji) < 16;
	}
	
	private boolean kawalerLubPanna(SytuacjaOsoby sytuacjaOsoby) {
		String kodStanuCywilnego = sytuacjaOsoby.getKodStanuCywilnego();
		return ImmutableSet.of("01", "02").contains(kodStanuCywilnego);
	}
}
