package pl.gov.mpips.zbc.v20200306;

import java.util.List;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W21Validator implements ComplexValidator<Problemy, SwiadczenieSprawozdawcze> {
	private static final ImmutableSet<String> PROBLEMATYCZNE = ImmutableSet.of("01", "02", "13");
	
	@Override
	public void validate(Problemy target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		SytuacjaRodziny sytuacjaRodziny = context.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return;
		//
		String kodRodzajuOpisuSytuacji = sytuacjaRodziny.getKodRodzajuOpisuSytuacji();
		List<String> kody = Listy.kody(target);
		for (int i = 0; i < kody.size(); i++) {
			if (kody.get(i) != null && !PROBLEMATYCZNE.contains(kodRodzajuOpisuSytuacji)) {
				errors.rejectValue("kod" + (i + 1), "W21", "Wybrany kod rodzaju opisu sytuacji rodziny wyklucza wskazywanie problemów");
			}
		}
	}
}
