package pl.gov.mpips.zbc.v20200306;

import java.util.List;

import com.google.common.base.Objects;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W22Validator1 implements SimpleValidator<SwiadczenieSprawozdawcze> {
	@Override
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		SytuacjaRodziny sytuacjaRodziny = target.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return;
		//
		if (!Objects.equal(wielkoscRodziny(sytuacjaRodziny), liczbaCzlonkowRodziny(target))) {
			errors.rejectValue("sytuacjaRodziny.wielkosc", "W22", "Wielkość rodziny musi być równa liczbie członków rodziny");
		}
	}
	
	private Integer wielkoscRodziny(SytuacjaRodziny sytuacjaRodziny) {
		return sytuacjaRodziny.getWielkosc();
	}
	
	private Integer liczbaCzlonkowRodziny(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
		List<CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
		return czlonkowieRodziny != null ? czlonkowieRodziny.size() : 0;
	}
}
