package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W26ValidatorSS implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final String GLOWA_RODZINY = "1";
	
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		SytuacjaRodziny sytuacjaRodziny = target.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return;
		List<CzlonekRodziny> czlonkowieRodziny = target.getCzlonkowieRodziny();
		if (czlonkowieRodziny == null) return;
		//
		long liczbaGlowRodziny = czlonkowieRodziny.stream()
			.map(CzlonekRodziny::getSytuacjaOsoby)
			.filter(Objects::nonNull)
			.map(SytuacjaOsoby::getKodRoliWRodzinie)
			.filter(Objects::nonNull)
			.filter(GLOWA_RODZINY::equals)
			.count();
		if (liczbaGlowRodziny != 1) {
			errors.rejectValue(null, "W26", "W rodzinie musi wystąpić dokładnie 1 osoba będąca głową rodziny");
		}
	}
}
