package pl.gov.mpips.zbc.v20200306;

import com.google.common.base.Strings;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W29Validator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final String POMOC_DLA_OSOB_USAMODZIELNIANYCH = "416";
	
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		String kodSwiadczenia = target.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		//
		if (kodSwiadczenia.startsWith(POMOC_DLA_OSOB_USAMODZIELNIANYCH)) {
			String kodRodzajuOpiekiUsamodzielnienie = target.getKodRodzajuOpiekiUsamodzielnienie();
			if (Strings.isNullOrEmpty(kodRodzajuOpiekiUsamodzielnienie)) {
				errors.rejectValue("kodRodzajuOpiekiUsamodzielnienie", "W29", "Określenie rodzaju opieki jest wymagane ze względu na kod świadczenia");
			}
		}
	}
}
