package pl.gov.mpips.zbc.v20200306;

import java.time.YearMonth;
import java.util.List;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.Kody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W31Validator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final Set<String> GRUPY = ImmutableSet.of("208", "209x", "408", "409x");
	private static final Set<String> POZYCJE = ImmutableSet.of("318050", "407x000");
	
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		String kodSwiadczenia = target.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		//
		if (Kody.prefiksy(kodSwiadczenia).anyMatch(GRUPY::contains)) return;
		if (POZYCJE.contains(kodSwiadczenia)) return;
		//
		List<YearMonth> przyslugujeZa = target.getPrzyslugujeZa();
		if (przyslugujeZa == null || przyslugujeZa.isEmpty()) {
			errors.rejectValue("przyslugujeZa", "W31", "Wskazanie okresu przysługiwania świadczenia jest wymagane ze względu na kod świadczenia");
		}
	}
}
