package pl.gov.mpips.zbc.v20200306;

import java.util.Objects;

import com.google.common.base.Strings;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W33Validator implements SimpleValidator<SytuacjaOsoby> {
	@Override
	public void validate(SytuacjaOsoby target, BasicErrors errors) {
		Boolean czyUstalonaGrupaInwalidzka = target.getCzyUstalonaGrupaInwalidzka();
		if (Objects.equals(czyUstalonaGrupaInwalidzka, Boolean.TRUE)) {
			String kodOrzeczeniaONiepelnosprawnosci = target.getKodOrzeczeniaONiepelnosprawnosci();
			if (Strings.isNullOrEmpty(kodOrzeczeniaONiepelnosprawnosci)) {
				errors.rejectValue("kodOrzeczeniaONiepelnosprawnosci", "W33", "Podanie kodu przeczenia o niepełnospraności jest wymagane");
			}
		}
	}
}
