package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W37Validator implements SimpleValidator<ZbiorCentralny> {
	@Override
	public void validate(ZbiorCentralny target, BasicErrors errors) {
		SetMultimap<SytuacjaRodziny, String> idRodzin = idRodzin(target);
		if (target.getSwiadczenia() != null) {
			for (int s = 0; s < target.getSwiadczenia().size(); s++) {
				SwiadczenieSprawozdawcze swiadczenie = target.getSwiadczenia().get(s);
				SytuacjaRodziny sytuacjaRodziny = swiadczenie.getSytuacjaRodziny();
				if (idRodzin.get(sytuacjaRodziny).size() > 1) {
					errors.rejectValue("swiadczenia[" + s + "].idRodziny", "W37",
						"Istnieją świadczenia, decyzje odmowne lub wnioski wskazujące na ten sam opis sytuacji rodziny, lecz inną rodzinę"
					);
				}
			}
		}
		if (target.getDecyzjeOdmowne() != null) {
			for (int d = 0; d < target.getDecyzjeOdmowne().size(); d++) {
				SprawozdawczaDecyzjaOdmowna decyzjaOdmowna = target.getDecyzjeOdmowne().get(d);
				SytuacjaRodziny sytuacjaRodziny = decyzjaOdmowna.getSytuacjaRodziny();
				if (idRodzin.get(sytuacjaRodziny).size() > 1) {
					errors.rejectValue("decyzjeOdmowne[" + d + "].idRodziny", "W37",
						"Istnieją świadczenia, decyzje odmowne lub wnioski wskazujące na ten sam opis sytuacji rodziny, lecz inną rodzinę"
					);
				}
			}
		}
		if (target.getWnioski() != null) {
			for (int w = 0; w < target.getWnioski().size(); w++) {
				WniosekSprawozdawczy wniosek = target.getWnioski().get(w);
				SytuacjaRodziny sytuacjaRodziny = wniosek.getSytuacjaRodziny();
				if (idRodzin.get(sytuacjaRodziny).size() > 1) {
					errors.rejectValue("wnioski[" + w + "].idRodziny", "W37",
						"Istnieją świadczenia, decyzje odmowne lub wnioski wskazujące na ten sam opis sytuacji rodziny, lecz inną rodzinę"
					);
				}
			}
		}
	}
	
	private SetMultimap<SytuacjaRodziny, String> idRodzin(ZbiorCentralny target) {
		ImmutableSetMultimap.Builder<SytuacjaRodziny, String> indeks = ImmutableSetMultimap.builder();
		if (target.getSwiadczenia() != null) {
			for (SwiadczenieSprawozdawcze swiadczenieSprawozdawcze : target.getSwiadczenia()) {
				if (swiadczenieSprawozdawcze.getSytuacjaRodziny() == null) continue;
				if (swiadczenieSprawozdawcze.getIdRodziny() == null) continue;
				indeks.put(swiadczenieSprawozdawcze.getSytuacjaRodziny(), swiadczenieSprawozdawcze.getIdRodziny());
			}
		}
		if (target.getDecyzjeOdmowne() != null) {
			for (SprawozdawczaDecyzjaOdmowna decyzjaOdmowna : target.getDecyzjeOdmowne()) {
				if (decyzjaOdmowna.getSytuacjaRodziny() == null) continue;
				if (decyzjaOdmowna.getIdRodziny() == null) continue;
				indeks.put(decyzjaOdmowna.getSytuacjaRodziny(), decyzjaOdmowna.getIdRodziny());
			}
		}
		if (target.getWnioski() != null) {
			for (WniosekSprawozdawczy wniosekSprawozdawczy : target.getWnioski()) {
				if (wniosekSprawozdawczy.getSytuacjaRodziny() == null) continue;
				if (wniosekSprawozdawczy.getIdRodziny() == null) continue;
				indeks.put(wniosekSprawozdawczy.getSytuacjaRodziny(), wniosekSprawozdawczy.getIdRodziny());
			}
		}
		return indeks.build();
	}
}
