package pl.gov.mpips.zbc.v20200306;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ZBRCENValidator implements Validator {
	private final ZbiorCentralnyValidator validator = new ZbiorCentralnyValidator();
	
	@Override
	public boolean supports(Class<?> clazz) {
		return clazz.equals(ZBRCEN.class);
	}
	
	@Override
	public void validate(Object target, Errors errors) {
		ZBRCEN zbrcen = (ZBRCEN) target;
		for (int z = 0; z < zbrcen.getZbioryCentralne().size(); z++) {
			ZbiorCentralny zbiorCentralny = zbrcen.getZbioryCentralne().get(z);
			if (zbiorCentralny != null) {
				errors.pushNestedPath("zbioryCentralne[" + z + "]");
				validator.validate(zbiorCentralny, errors);
				errors.popNestedPath();
			}
		}
	}
}
