package pl.gov.mpips.zbc.v20200306;

import static com.google.common.base.MoreObjects.firstNonNull;
import static com.google.common.base.Preconditions.checkNotNull;

import java.util.List;
import java.util.Map;

import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

public class ZbiorCentralnyListener {
	private final ZbiorCentralny zbiorCentralny;

	public ZbiorCentralnyListener(ZbiorCentralny zbiorCentralny) {
		this.zbiorCentralny = checkNotNull(zbiorCentralny);
	}

	void beforeMarshal(Marshaller marshaller) {
		if (zbiorCentralny.getSwiadczenia() != null && zbiorCentralny.getSwiadczenia().isEmpty()) {
			zbiorCentralny.setSwiadczenia(null);
		}
		if (zbiorCentralny.getWydatkiSrodkow() != null && zbiorCentralny.getWydatkiSrodkow().isEmpty()) {
			zbiorCentralny.setWydatkiSrodkow(null);
		}
		if (zbiorCentralny.getDecyzjeOdmowne() != null && zbiorCentralny.getDecyzjeOdmowne().isEmpty()) {
			zbiorCentralny.setDecyzjeOdmowne(null);
		}
		if (zbiorCentralny.getWnioski() != null && zbiorCentralny.getWnioski().isEmpty()) {
			zbiorCentralny.setWnioski(null);
		}
		if (zbiorCentralny.getSytuacjeRodzin() != null && zbiorCentralny.getSytuacjeRodzin().isEmpty()) {
			zbiorCentralny.setSytuacjeRodzin(null);
		}
		if (zbiorCentralny.getSytuacjeOsob() != null && zbiorCentralny.getSytuacjeOsob().isEmpty()) {
			zbiorCentralny.setSytuacjeOsob(null);
		}
	}

	void afterMarshal(Marshaller marshaller) {
	}

	void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) {
	}

	void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
		Map<String, SytuacjaOsoby> sytuacjeOsob = sytuacjeOsob(zbiorCentralny);
		Map<String, SytuacjaRodziny> sytuacjeRodzin = sytuacjeRodzin(zbiorCentralny);
		if (zbiorCentralny.getDecyzjeOdmowne() != null) {
			zbiorCentralny.getDecyzjeOdmowne().forEach(decyzjaOdmowna -> {
				decyzjaOdmowna.setSytuacjaOsoby(zamiennik(decyzjaOdmowna.getSytuacjaOsoby(), sytuacjeOsob));
				decyzjaOdmowna.setSytuacjaRodziny(zamiennik(decyzjaOdmowna.getSytuacjaRodziny(), sytuacjeRodzin));
			});
		}
		if (zbiorCentralny.getSwiadczenia() != null) {
			zbiorCentralny.getSwiadczenia().forEach(swiadczenie -> {
				swiadczenie.setSytuacjaRodziny(zamiennik(swiadczenie.getSytuacjaRodziny(), sytuacjeRodzin));
				if (swiadczenie.getCzlonkowieRodziny() != null) {
					swiadczenie.getCzlonkowieRodziny().forEach(czlonekRodziny -> {
						czlonekRodziny.setSytuacjaOsoby(zamiennik(czlonekRodziny.getSytuacjaOsoby(), sytuacjeOsob));
					});
				}
			});
		}
		if (zbiorCentralny.getWnioski() != null) {
			zbiorCentralny.getWnioski().forEach(wniosek -> {
				wniosek.setSytuacjaOsoby(zamiennik(wniosek.getSytuacjaOsoby(), sytuacjeOsob));
				wniosek.setSytuacjaRodziny(zamiennik(wniosek.getSytuacjaRodziny(), sytuacjeRodzin));
			});
		}
	}

	private static ImmutableMap<String, SytuacjaOsoby> sytuacjeOsob(ZbiorCentralny zbiorCentralny) {
		List<SytuacjaOsoby> sytuacjeOsob = firstNonNull(zbiorCentralny.getSytuacjeOsob(), ImmutableList.of());
		return Maps.uniqueIndex(sytuacjeOsob, SytuacjaOsoby::getIdSytuacjiOsoby);
	}

	private static ImmutableMap<String, SytuacjaRodziny> sytuacjeRodzin(ZbiorCentralny zbiorCentralny) {
		List<SytuacjaRodziny> sytuacjeRodzin = firstNonNull(zbiorCentralny.getSytuacjeRodzin(), ImmutableList.of());
		return Maps.uniqueIndex(sytuacjeRodzin, SytuacjaRodziny::getIdSytuacjiRodziny);
	}

	private static SytuacjaOsoby zamiennik(SytuacjaOsoby namiastka, Map<String, SytuacjaOsoby> indeks) {
		return namiastka == null ? null : indeks.get(namiastka.getIdSytuacjiOsoby());
	}

	private static SytuacjaRodziny zamiennik(SytuacjaRodziny namiastka, Map<String, SytuacjaRodziny> indeks) {
		return namiastka == null ? null : indeks.get(namiastka.getIdSytuacjiRodziny());
	}
}
