package pl.gov.mpips.zbc.v20200306.narzedzia;

import java.util.AbstractList;
import java.util.List;

import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna.PowodyOdmowy;
import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna.SwiadczeniaOdmowione;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby.Dochody;

public final class Listy {
	private Listy() {}
	
	public static List<String> kody(Problemy problemy) {
		return new AbstractList<String>() {
			@Override
			public String get(int index) {
				switch (index) {
					case 0: return problemy.getKod1();
					case 1: return problemy.getKod2();
					case 2: return problemy.getKod3();
					case 3: return problemy.getKod4();
					case 4: return problemy.getKod5();
					default: throw new IndexOutOfBoundsException();
				}
			}
			
			@Override
			public String set(int index, String element) {
				String oldValue = get(index);
				switch (index) {
					case 0: problemy.setKod1(element); return oldValue;
					case 1: problemy.setKod2(element); return oldValue;
					case 2: problemy.setKod3(element); return oldValue;
					case 3: problemy.setKod4(element); return oldValue;
					case 4: problemy.setKod5(element); return oldValue;
					default: throw new AssertionError();
				}
			}
			
			@Override
			public int size() {
				return 5;
			}
		};
	}
	
	public static List<String> kodyPowodow(PowodyOdmowy powodyOdmowy) {
		return new AbstractList<String>() {
			@Override
			public String get(int index) {
				switch (index) {
					case 0: return powodyOdmowy.getKodPowodu1();
					case 1: return powodyOdmowy.getKodPowodu2();
					case 2: return powodyOdmowy.getKodPowodu3();
					default: throw new IndexOutOfBoundsException();
				}
			}
			
			@Override
			public String set(int index, String element) {
				String oldValue = get(index);
				switch (index) {
					case 0: powodyOdmowy.setKodPowodu1(element); return oldValue;
					case 1: powodyOdmowy.setKodPowodu2(element); return oldValue;
					case 2: powodyOdmowy.setKodPowodu3(element); return oldValue;
					default: throw new AssertionError();
				}
			}
			
			@Override
			public int size() {
				return 3;
			}
		};
	}
	
	public static List<String> kodyPowodowUsamodzielnienie(PowodyOdmowy powodyOdmowy) {
		return new AbstractList<String>() {
			@Override
			public String get(int index) {
				switch (index) {
					case 0: return powodyOdmowy.getKodPowoduUsamodzielnienie1();
					case 1: return powodyOdmowy.getKodPowoduUsamodzielnienie2();
					case 2: return powodyOdmowy.getKodPowoduUsamodzielnienie3();
					default: throw new IndexOutOfBoundsException();
				}
			}
			
			@Override
			public String set(int index, String element) {
				String oldValue = get(index);
				switch (index) {
					case 0: powodyOdmowy.setKodPowoduUsamodzielnienie1(element); return oldValue;
					case 1: powodyOdmowy.setKodPowoduUsamodzielnienie2(element); return oldValue;
					case 2: powodyOdmowy.setKodPowoduUsamodzielnienie3(element); return oldValue;
					default: throw new AssertionError();
				}
			}
			
			@Override
			public int size() {
				return 3;
			}
		};
	}
	
	public static List<String> kodyPowodowCudzoziemcy(PowodyOdmowy powodyOdmowy) {
		return new AbstractList<String>() {
			@Override
			public String get(int index) {
				switch (index) {
					case 0: return powodyOdmowy.getKodPowoduCudzoziemcy1();
					case 1: return powodyOdmowy.getKodPowoduCudzoziemcy2();
					case 2: return powodyOdmowy.getKodPowoduCudzoziemcy3();
					default: throw new IndexOutOfBoundsException();
				}
			}
			
			@Override
			public String set(int index, String element) {
				String oldValue = get(index);
				switch (index) {
					case 0: powodyOdmowy.setKodPowoduCudzoziemcy1(element); return oldValue;
					case 1: powodyOdmowy.setKodPowoduCudzoziemcy2(element); return oldValue;
					case 2: powodyOdmowy.setKodPowoduCudzoziemcy3(element); return oldValue;
					default: throw new AssertionError();
				}
			}

			@Override
			public int size() {
				return 3;
			}
		};
	}
	
	public static List<String> kodyRodzaju(SwiadczeniaOdmowione swiadczeniaOdmowione) {
		return new AbstractList<String>() {
			@Override
			public String get(int index) {
				switch (index) {
					case 0: return swiadczeniaOdmowione.getKodRodzaju1();
					case 1: return swiadczeniaOdmowione.getKodRodzaju2();
					case 2: return swiadczeniaOdmowione.getKodRodzaju3();
					case 3: return swiadczeniaOdmowione.getKodRodzaju4();
					case 4: return swiadczeniaOdmowione.getKodRodzaju5();
					default: throw new IndexOutOfBoundsException();
				}
			}
			
			@Override
			public String set(int index, String element) {
				String oldValue = get(index);
				switch (index) {
					case 0: swiadczeniaOdmowione.setKodRodzaju1(element); return oldValue;
					case 1: swiadczeniaOdmowione.setKodRodzaju2(element); return oldValue;
					case 2: swiadczeniaOdmowione.setKodRodzaju3(element); return oldValue;
					case 3: swiadczeniaOdmowione.setKodRodzaju4(element); return oldValue;
					case 4: swiadczeniaOdmowione.setKodRodzaju5(element); return oldValue;
					default: throw new AssertionError();
				}
			}
			
			@Override
			public int size() {
				return 5;
			}
		};
	}
	
	public static List<String> zrodla(Dochody dochody) {
		return new AbstractList<String>() {
			@Override
			public String get(int index) {
				switch (index) {
					case 0: return dochody.getZrodlo1();
					case 1: return dochody.getZrodlo2();
					case 2: return dochody.getZrodlo3();
					case 3: return dochody.getZrodlo4();
					default: throw new IndexOutOfBoundsException();
				}
			}
			
			@Override
			public String set(int index, String element) {
				String oldValue = get(index);
				switch (index) {
					case 0: dochody.setZrodlo1(element); return oldValue;
					case 1: dochody.setZrodlo2(element); return oldValue;
					case 2: dochody.setZrodlo3(element); return oldValue;
					case 3: dochody.setZrodlo4(element); return oldValue;
					default: throw new AssertionError();
				}
			}
			
			@Override
			public int size() {
				return 4;
			}
		};
	}
}
