/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W01ValidatorSO
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    @Override
    public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
        this.require(target, context, errors, "dataUrodzenia", SytuacjaOsoby::getDataUrodzenia, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13"));
        this.require(target, context, errors, "kodStanuCywilnego", SytuacjaOsoby::getKodStanuCywilnego, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13"));
        this.require(target, context, errors, "kodRoliWRodzinie", SytuacjaOsoby::getKodRoliWRodzinie, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13"));
        this.require(target, context, errors, "kodPokrewienstwaZGlowaRodziny", SytuacjaOsoby::getKodPokrewienstwaZGlowaRodziny, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13"));
        this.require(target, context, errors, "kodRodzajuWyksztalcenia", SytuacjaOsoby::getKodRodzajuWyksztalcenia, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13"));
        this.require(target, context, errors, "kodPozycjiNaRynkuPracy", SytuacjaOsoby::getKodPozycjiNaRynkuPracy, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"13"));
        this.require(target, context, errors, "kodStanuZdrowia", SytuacjaOsoby::getKodStanuZdrowia, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13"));
        this.require(target, context, errors, "czyNiepelnosprawny", SytuacjaOsoby::getCzyNiepelnosprawny, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"13"));
        this.require(target, context, errors, "czyUstalonaGrupaInwalidzka", SytuacjaOsoby::getCzyUstalonaGrupaInwalidzka, (Set<String>)ImmutableSet.of((Object)"01", (Object)"02", (Object)"13"));
    }

    private void require(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors, String field, Function<SytuacjaOsoby, Object> getter, Set<String> codes) {
        Object wartosc;
        String kod = context.getKodRodzajuOpisuSytuacji();
        if (codes.contains(kod) && this.isEmpty(wartosc = getter.apply(target))) {
            errors.rejectValue(field, "W01", this.opis(field) + " jest wymagane dla wybranego kodu rodzaju opisu sytuacji");
        }
    }

    private boolean isEmpty(Object value) {
        if (value instanceof String) {
            return Strings.isNullOrEmpty((String)((String)value));
        }
        return Objects.isNull(value);
    }

    private String opis(String field) {
        switch (field) {
            case "dataUrodzenia": {
                return "Podanie daty urodzenia";
            }
            case "kodStanuCywilnego": {
                return "Uzupe\u0142nienie kodu stanu cywilnego";
            }
            case "kodRoliWRodzinie": {
                return "Uzupe\u0142nienie kodu roli w rodzinie";
            }
            case "kodPokrewienstwaZGlowaRodziny": {
                return "Uzupe\u0142nienie kodu pokrewie\u0144stwa z g\u0142ow\u0105 rodziny";
            }
            case "kodRodzajuWyksztalcenia": {
                return "Uzupe\u0142nienie kodu rodzaju wykszta\u0142cenia";
            }
            case "kodPozycjiNaRynkuPracy": {
                return "Uzupe\u0142nienie kodu pozycji na rynku pracy";
            }
            case "kodStanuZdrowia": {
                return "Uzupe\u0142nienie kodu stanu zdrowia";
            }
            case "czyNiepelnosprawny": {
                return "Wskazanie czy niepe\u0142nosprawny";
            }
            case "czyUstalonaGrupaInwalidzka": {
                return "Wskazanie czy ustalono grup\u0119 inwalidzk\u0105";
            }
        }
        throw new IllegalArgumentException();
    }
}

