/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W03aValidator
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    private static final ImmutableSet<String> DOCHODY_WYMAGANE = ImmutableSet.of((Object)"01", (Object)"02", (Object)"06", (Object)"11", (Object)"13");

    @Override
    public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
        String kodRodzajuOpisuSytuacji = context.getKodRodzajuOpisuSytuacji();
        if (DOCHODY_WYMAGANE.contains((Object)kodRodzajuOpisuSytuacji)) {
            SytuacjaOsoby.Dochody dochody = sytuacjaOsoby.getDochody();
            if (dochody == null) {
                return;
            }
            if (Strings.isNullOrEmpty((String)dochody.getZrodlo1())) {
                errors.rejectValue("dochody.zrodlo1", "W03a", "Podanie kodu \u017ar\u00f3d\u0142a dochodu jest wymagane ze wzgl\u0119du na kod rodzaju opisu sytuacji rodziny");
            }
            if (Objects.isNull(dochody.getKwotaMiesiecznie1())) {
                errors.rejectValue("dochody.kwotaMiesiecznie1", "W03a", "Podanie kwoty dochodu jest wymagane ze wzgl\u0119du na kod rodzaju opisu sytuacji rodziny");
            }
        }
    }
}

