/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W09aValidator
implements SimpleValidator<SwiadczenieSprawozdawcze> {
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> MEZCZYZNA = this.plec("1");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> KOBIETA = this.plec("2");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> ZONATY = this.stanCywilny("03");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> ZAMEZNA = this.stanCywilny("04");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> MAZ = this.stopienPokrewienstwa("15");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> ZONA = this.stopienPokrewienstwa("16");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> POKREWIENSTWO_NIEOKRESLONE = this.stopienPokrewienstwa("98");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> GLOWA = this.kodRoliWRodzinie("1");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> CZLONEK = this.GLOWA.negate();

    @Override
    public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
        if (this.weryfikowalne(target) && !this.poprawne(target)) {
            errors.rejectValue(null, "W09a", "Niepoprawne warto\u015bci Kodu roli w rodzinie, Kodu p\u0142ci, Kodu stopnia pokrewie\u0144stwa i Kodu stanu cywilnego w ramach jednej sytuacji rodziny");
        }
    }

    private boolean weryfikowalne(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
        List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
        if (czlonkowieRodziny == null) {
            return false;
        }
        return !czlonkowieRodziny.stream().map(SwiadczenieSprawozdawcze.CzlonekRodziny::getSytuacjaOsoby).anyMatch(Objects::isNull);
    }

    private boolean poprawne(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
        List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
        int mezczyznaGlowa = (int)czlonkowieRodziny.stream().filter(this.MEZCZYZNA.and(this.GLOWA).and(this.POKREWIENSTWO_NIEOKRESLONE)).count();
        int kobietaGlowa = (int)czlonkowieRodziny.stream().filter(this.KOBIETA.and(this.GLOWA).and(this.POKREWIENSTWO_NIEOKRESLONE)).count();
        int mazCzlonek = (int)czlonkowieRodziny.stream().filter(this.MEZCZYZNA.and(this.CZLONEK).and(this.ZONATY).and(this.MAZ)).count();
        int zonaCzlonek = (int)czlonkowieRodziny.stream().filter(this.KOBIETA.and(this.CZLONEK).and(this.ZAMEZNA).and(this.ZONA)).count();
        if (mezczyznaGlowa == 1) {
            return kobietaGlowa == 0 && mazCzlonek == 0 && zonaCzlonek < 2;
        }
        if (kobietaGlowa == 1) {
            return mezczyznaGlowa == 0 && zonaCzlonek == 0 && mazCzlonek < 2;
        }
        return true;
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> plec(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getKodPlci());
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> stanCywilny(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodStanuCywilnego());
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> stopienPokrewienstwa(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodPokrewienstwaZGlowaRodziny());
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> kodRoliWRodzinie(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodRoliWRodzinie());
    }
}

