/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collections;
import java.util.List;
import pl.gov.mpips.zbc.Kody;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W20aValidator1
implements ComplexValidator<SytuacjaRodziny, SwiadczenieSprawozdawcze> {
    private static final ImmutableSet<String> WYLACZONE = ImmutableSet.of((Object)"111000", (Object)"115000", (Object)"118000", (Object)"140", (Object)"206000", (Object)"207", (Object[])new String[]{"208", "209x", "214", "214x", "214y", "217000", "320", "408", "409x", "4302", "202040", "202050", "190051"});

    @Override
    public void validate(SytuacjaRodziny target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
        LocalDate dataOpisuSytuacji = target.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return;
        }
        String kodSwiadczenia = context.getKodSwiadczenia();
        if (kodSwiadczenia == null) {
            return;
        }
        List<YearMonth> przyslugujeZa = context.getPrzyslugujeZa();
        if (przyslugujeZa == null) {
            return;
        }
        if (Kody.prefiksy(kodSwiadczenia).anyMatch(arg_0 -> WYLACZONE.contains(arg_0))) {
            return;
        }
        if (przyslugujeZa.isEmpty()) {
            return;
        }
        YearMonth ostatniMiesiac = Collections.max(przyslugujeZa);
        if (dataOpisuSytuacji.isBefore(ostatniMiesiac.atDay(1).minusMonths(6L))) {
            errors.rejectValue("dataOpisuSytuacji", "W20a", "Data opisu sytuacji nie mo\u017ce by\u0107 wcze\u015bniejsza ni\u017c data wcze\u015bniejsza o p\u00f3\u0142 roku od pierwszego dnia najp\u00f3\u017cniejszego miesi\u0105ca, za kt\u00f3ry przys\u0142uguje \u015bwiadczenie");
        }
    }
}

