/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;
import java.time.YearMonth;
import java.util.List;
import java.util.Set;
import pl.gov.mpips.zbc.Kody;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W31Validator
implements SimpleValidator<SwiadczenieSprawozdawcze> {
    private static final Set<String> GRUPY = ImmutableSet.of((Object)"208", (Object)"209x", (Object)"408", (Object)"409x");
    private static final Set<String> POZYCJE = ImmutableSet.of((Object)"318050", (Object)"407x000");

    @Override
    public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
        String kodSwiadczenia = target.getKodSwiadczenia();
        if (kodSwiadczenia == null) {
            return;
        }
        if (Kody.prefiksy(kodSwiadczenia).anyMatch(GRUPY::contains)) {
            return;
        }
        if (POZYCJE.contains(kodSwiadczenia)) {
            return;
        }
        List<YearMonth> przyslugujeZa = target.getPrzyslugujeZa();
        if (przyslugujeZa == null || przyslugujeZa.isEmpty()) {
            errors.rejectValue("przyslugujeZa", "W31", "Wskazanie okresu przys\u0142ugiwania \u015bwiadczenia jest wymagane ze wzgl\u0119du na kod \u015bwiadczenia");
        }
    }
}

