/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W36Validator
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    private static final ImmutableSet<String> WYKSZTALCENIE_WYZSZE = ImmutableSet.of((Object)"10", (Object)"15");

    @Override
    public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
        if (this.zaWczesnieNaStudia(target, context) && this.wyksztalcenieWyzsze(target)) {
            errors.rejectValue("kodRodzajuWyksztalcenia", "W36", "U os\u00f3b m\u0142odszych ni\u017c 18 lat nie mo\u017cna wskaza\u0107 wykszta\u0142cenia wy\u017cszego");
        }
    }

    private boolean zaWczesnieNaStudia(SytuacjaOsoby target, SytuacjaRodziny context) {
        LocalDate dataUrodzenia = target.getDataUrodzenia();
        if (dataUrodzenia == null) {
            return false;
        }
        LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return false;
        }
        return ExtraChronoUnit.LEGAL_YEARS.between((Temporal)dataUrodzenia, (Temporal)dataOpisuSytuacji) < 18L;
    }

    private boolean wyksztalcenieWyzsze(SytuacjaOsoby sytuacjaOsoby) {
        String kodRodzajuWyksztalcenia = sytuacjaOsoby.getKodRodzajuWyksztalcenia();
        return WYKSZTALCENIE_WYZSZE.contains((Object)kodRodzajuWyksztalcenia);
    }
}

