/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import java.time.LocalDate;
import org.threeten.extra.YearQuarter;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.ZbiorCentralny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W19Validator
implements ComplexValidator<SwiadczenieSprawozdawcze, ZbiorCentralny> {
    @Override
    public void validate(SwiadczenieSprawozdawcze target, ZbiorCentralny context, BasicErrors errors) {
        LocalDate dataPierwszegoSwiadczenia = target.getDataPierwszegoSwiadczenia();
        Integer okresSwiadczenia = target.getOkresSwiadczenia();
        YearQuarter okresSprawozdawczy = context.getOkres();
        if (dataPierwszegoSwiadczenia != null && okresSwiadczenia != null && okresSprawozdawczy != null) {
            LocalDate poczatekKwartalu = okresSprawozdawczy.atDay(1);
            LocalDate koniecKwartalu = okresSprawozdawczy.atEndOfQuarter();
            if (dataPierwszegoSwiadczenia.isBefore(poczatekKwartalu.minusMonths(okresSwiadczenia + 6))) {
                errors.rejectValue("dataPierwszegoSwiadczenia", "W19", "Data pierwszego \u015bwiadczenia jest niezgodna z okresem \u015bwiadczenia");
            }
            if (dataPierwszegoSwiadczenia.isAfter(koniecKwartalu)) {
                errors.rejectValue("dataPierwszegoSwiadczenia", "W19", "Data pierwszego \u015bwiadczenia jest p\u00f3\u017aniejsza ni\u017c koniec kwarta\u0142u");
            }
        }
    }
}

