<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:xs="http://www.w3.org/2001/XMLSchema"
		version="1.0">
	<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" indent="no" method="html"/>

	<xsl:decimal-format name="pln" decimal-separator="," grouping-separator=" "/>

	<xsl:template match="/">
		<div class="container-fluid">
			<xsl:text> </xsl:text>
		</div>
		<div class="container-fluid">
			<xsl:call-template name="Zbiory"/>
		</div>
		<div class="container-fluid">
			<xsl:text> </xsl:text>
		</div>
	</xsl:template>

	<xsl:template name="Zbiory">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny">
			<div class="container-fluid col-md-offset-2 col-md-8">
			<form name="zbiory">
				<fieldset>
					<legend>Dane zbioru centralnego</legend>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">za kwartał</label>
						<div class="col-md-5">
							<xsl:value-of select="Za_Okres/Rok"/>Q<xsl:value-of select="Za_Okres/Kwartal"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">nr wykonania</label>
						<div class="col-md-5">
							<xsl:value-of select="Nr_Wykonania_Zbc"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">wymagania</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/@Wersja_Wymagan"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">formularz</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/@Wersja_Formularza"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">data utworzenia</label>
						<div class="col-md-5">
							<xsl:value-of select="Data_Utworzenia"/>
						</div>
					</div>
				</fieldset>
				<fieldset>
					<legend>Dane jednostki utworzenia</legend>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">KESO</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/@Kod_KESO"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">nazwa</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/Pelna_Nazwa"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">aplikacja</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/@Kod_Aplikacji"/> (<xsl:value-of select="/P_ZBRCEN/@Wersja_Aplikacji"/>)
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">zestaw słowników</label>
						<div class="col-md-5">
							<xsl:value-of select="Nr_Zestawu_Slownikow"/>
						</div>
					</div>
				</fieldset>
				<fieldset>
					<legend>Zawartość</legend>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">
							liczba rodzin
							<br/><small>(w bazie PS)</small>
						</label>
						<div class="col-md-5">
							<xsl:value-of select="Liczba_Rodzin_W_Systemie"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">
							liczba wywiadów
							<br/><small>(w bazie PS)</small>
						</label>
						<div class="col-md-5">
							<xsl:value-of select="Liczba_Utworzonych_Wywiadow"/>
						</div>
					</div>
					<div class="row form-group">
						<table class="table table-bordered table-hover" style="width: 95%; margin-left: auto; margin-right: auto;">
							<thead>
								<tr>
									<th style="width: 28%;">Informacja</th>
									<th style="width: 18%;">Kwartał 1</th>
									<th style="width: 18%;">Kwartał 2</th>
									<th style="width: 18%;">Kwartał 3</th>
									<th style="width: 18%;">Kwartał 4</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>Wartość świadczeń POMOST</td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw1, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw2, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw3, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw4, '0,00', 'pln')"/></td>
								</tr>
								<tr>
									<td>Wartość świadczeń RB28-S</td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw1, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw2, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw3, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw4, '0,00', 'pln')"/></td>
								</tr>
								<tr>
									<td>Procent zgodności</td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw1"/></td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw2"/></td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw3"/></td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw4"/></td>
								</tr>
							</tbody>
						</table>
					</div>
				</fieldset>
			</form>
			</div>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
