/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20090722.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W35Validator
implements ComplexValidator<SytuacjaRodziny, SwiadczenieSprawozdawcze> {
    private static final ImmutableSet<String> PROBLEM_WIELODZIETNOSCI = ImmutableSet.of((Object)"043", (Object)"082");
    private static final ImmutableSet<String> POTENCJALNA_WIELODZIETNOSC = ImmutableSet.of((Object)"123", (Object)"124", (Object)"125", (Object)"126", (Object)"127", (Object)"133", (Object[])new String[]{"134", "137", "138", "153", "154", "155", "156", "157", "211", "219", "221", "229", "230", "320", "400"});

    @Override
    public void validate(SytuacjaRodziny target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
        if (this.wskazanoProblemWielodzietnosci(context) && !this.kodSkladuRodzinyDopuszczaWielodzietnosc(target)) {
            errors.rejectValue("kodSkladuRodziny", "W35", "Warto\u015b\u0107 kodu sk\u0142adu rodziny jest niezgodna z jednym z kod\u00f3w rodzaju problemu wskazanym w \u015bwiadczeniu (wielodzietno\u015b\u0107)");
        }
    }

    private boolean wskazanoProblemWielodzietnosci(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
        SwiadczenieSprawozdawcze.Problemy problemy = swiadczenieSprawozdawcze.getProblemy();
        if (problemy == null) {
            return false;
        }
        return Listy.kody(problemy).stream().anyMatch(arg_0 -> PROBLEM_WIELODZIETNOSCI.contains(arg_0));
    }

    private boolean kodSkladuRodzinyDopuszczaWielodzietnosc(SytuacjaRodziny sytuacjaRodziny) {
        String kodSkladuRodziny = sytuacjaRodziny.getKodSkladuRodziny();
        return POTENCJALNA_WIELODZIETNOSC.contains((Object)kodSkladuRodziny);
    }
}

