/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.base.Objects;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W16Validator
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    @Override
    public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
        if (this.zaWczesnieNaNauke(sytuacjaOsoby, context) && !this.brakWyksztalcenia(sytuacjaOsoby)) {
            errors.rejectValue("kodRodzajuWyksztalcenia", "W16", "U os\u00f3b m\u0142odszych ni\u017c 5 lat nale\u017cy wskaza\u0107 brak wykszta\u0142cenia");
        }
    }

    private boolean zaWczesnieNaNauke(SytuacjaOsoby target, SytuacjaRodziny context) {
        LocalDate dataUrodzenia = target.getDataUrodzenia();
        if (dataUrodzenia == null) {
            return false;
        }
        LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return false;
        }
        return ExtraChronoUnit.LEGAL_YEARS.between((Temporal)dataUrodzenia, (Temporal)dataOpisuSytuacji) < 5L;
    }

    private boolean brakWyksztalcenia(SytuacjaOsoby sytuacjaOsoby) {
        String kodRodzajuWyksztalcenia = sytuacjaOsoby.getKodRodzajuWyksztalcenia();
        return Objects.equal((Object)kodRodzajuWyksztalcenia, (Object)"70");
    }
}

