/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.pomost.integracja.zbc.v20090722.adaptery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import pl.gov.mpips.zbc.v20090722.ObjectFactory;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze;

public final class PrzyslugujeZaAdapter
extends XmlAdapter<SwiadczenieSprawozdawcze.PrzyslugujeZa, List<YearMonth>> {
    private final ObjectFactory fabryka = new ObjectFactory();

    public List<YearMonth> unmarshal(SwiadczenieSprawozdawcze.PrzyslugujeZa v) throws Exception {
        if (v == null) {
            return null;
        }
        if (v.getRokAndMiesiac() == null) {
            return null;
        }
        if (v.getRokAndMiesiac().isEmpty()) {
            return null;
        }
        ArrayList<YearMonth> przyslugujeZa = new ArrayList<YearMonth>();
        Lists.partition(v.getRokAndMiesiac(), (int)2).stream().map(this::deserializuj).forEach(przyslugujeZa::add);
        return przyslugujeZa;
    }

    public SwiadczenieSprawozdawcze.PrzyslugujeZa marshal(List<YearMonth> v) throws Exception {
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return null;
        }
        SwiadczenieSprawozdawcze.PrzyslugujeZa przyslugujeZa = new SwiadczenieSprawozdawcze.PrzyslugujeZa();
        v.stream().flatMap(this::serializuj).forEach(przyslugujeZa.getRokAndMiesiac()::add);
        return przyslugujeZa;
    }

    private YearMonth deserializuj(List<JAXBElement<? extends Serializable>> partycja) {
        Preconditions.checkArgument((partycja.size() == 2 ? 1 : 0) != 0);
        JAXBElement<? extends Serializable> rok = partycja.get(0);
        JAXBElement<? extends Serializable> miesiac = partycja.get(1);
        return YearMonth.of(((Year)rok.getValue()).getValue(), (Month)miesiac.getValue());
    }

    private Stream<JAXBElement<? extends Serializable>> serializuj(YearMonth yearMonth) {
        return Stream.of(this.fabryka.createSwiadczenieSprawozdawczePrzyslugujeZaRok(Year.of(yearMonth.getYear())), this.fabryka.createSwiadczenieSprawozdawczePrzyslugujeZaMiesiac(yearMonth.getMonth()));
    }
}

