/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import java.time.LocalDate;
import org.threeten.extra.YearQuarter;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.gov.mpips.zbc.v20200306.ZbiorCentralny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W20aValidator2
implements ComplexValidator<SwiadczenieSprawozdawcze, ZbiorCentralny> {
    @Override
    public void validate(SwiadczenieSprawozdawcze target, ZbiorCentralny context, BasicErrors errors) {
        SytuacjaRodziny sytuacjaRodziny = target.getSytuacjaRodziny();
        if (sytuacjaRodziny == null) {
            return;
        }
        LocalDate dataOpisuSytuacji = sytuacjaRodziny.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return;
        }
        YearQuarter okresSprawozdawczy = context.getOkres();
        if (okresSprawozdawczy == null) {
            return;
        }
        if (dataOpisuSytuacji.isAfter(okresSprawozdawczy.atEndOfQuarter())) {
            errors.rejectValue("sytuacjaRodziny.dataOpisuSytuacji", "W20a", "Data opisu sytuacji nie mo\u017ce by\u0107 p\u00f3\u017aniejsza ni\u017c ostatni dzie\u0144 kwarta\u0142u za kt\u00f3ry przesy\u0142amy dane w zbiorze centralnym");
        }
    }
}

