<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes">
    <xsl:output version="1.0" encoding="UTF-8" indent="no" omit-xml-declaration="no" media-type="text/html" />
    <xsl:template match="/">
        <html>
            <head>
                <title />
            </head>
            <body>
                <xsl:for-each select="Zbiór_Centralny">
                    <br />
                    <span style="font-family:Times New Roman; font-size:larger; font-weight:bold; ">I. Zbiór centralny</span>
                    <br />
                    <br />
                    <table border="1" cellpadding="2" cellspacing="0" width="100%">
                        <tbody>
                            <tr>
                                <td height="25">
                                    <span style="font-weight:bold; ">Kod Keso</span>
                                </td>
                                <td colspan="4" height="25">
                                    <xsl:for-each select="Kod_KESO">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Rok</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Rok">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Kwartał</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Kwartał">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Nr wykonania</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Nr_Wykonania_Zbc">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Data utworzenia</span>
                                </td>
                                <td align="left" colspan="4">
                                    <xsl:for-each select="Data_Utworzenia">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Kod aplikacji</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Kod_Aplikacji">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Wersja aplikacji</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Wersja_Aplikacji">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Nr słowników</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Nr_Zestawu_Słowników">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Liczba rodzin</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Liczba_Rodzin_W_Systemie">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Liczba wywiadów</span>
                                </td>
                                <td colspan="4">
                                    <xsl:for-each select="Liczba_Utworzonych_Wywiadów">
                                        <xsl:apply-templates />
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="font-weight:bold; ">Wartość świadczeń</span>
                                </td>
                                <td align="center" colspan="2">
                                    <span style="font-style:italic; font-weight:bold; ">POMOST</span>
                                </td>
                                <td align="center" colspan="2">
                                    <span style="font-style:italic; font-weight:bold; ">RB28-S</span>
                                </td>
                            </tr>
                            <tr>
                                <td align="right">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 1</span>
                                </td>
                                <td align="center" colspan="2">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="POMOST">
                                            <xsl:for-each select="Kw1">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center" colspan="2">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="RB28-S">
                                            <xsl:for-each select="Kw1">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td align="right" height="25">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 2</span>
                                </td>
                                <td align="center" colspan="2" height="25">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="POMOST">
                                            <xsl:for-each select="Kw2">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center" colspan="2" height="25">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="RB28-S">
                                            <xsl:for-each select="Kw2">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td align="right">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 3</span>
                                </td>
                                <td align="center" colspan="2">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="POMOST">
                                            <xsl:for-each select="Kw3">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center" colspan="2">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="RB28-S">
                                            <xsl:for-each select="Kw3">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td align="right">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał </span>
                                    <span style="font-weight:bold; ">4</span>
                                </td>
                                <td align="center" colspan="2">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="POMOST">
                                            <xsl:for-each select="Kw4">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center" colspan="2">
                                    <xsl:for-each select="Wartość_Świadczeń">
                                        <xsl:for-each select="RB28-S">
                                            <xsl:for-each select="Kw4">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td align="left" rowspan="2">
                                    <span style="font-weight:bold; ">Procent zgodności</span>
                                </td>
                                <td align="center">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 1</span>
                                </td>
                                <td align="center">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 2</span>
                                </td>
                                <td align="center">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 3</span>
                                </td>
                                <td align="center">
                                    <span style="font-style:italic; font-weight:bold; ">Kwartał 4</span>
                                </td>
                            </tr>
                            <tr>
                                <td align="center">
                                    <xsl:for-each select="Procent_Zgodności">
                                        <xsl:for-each select="Kw1">
                                            <xsl:apply-templates />
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center">
                                    <xsl:for-each select="Procent_Zgodności">
                                        <xsl:for-each select="Kw2">
                                            <xsl:apply-templates />
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center">
                                    <xsl:for-each select="Procent_Zgodności">
                                        <xsl:for-each select="Kw3">
                                            <xsl:apply-templates />
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                                <td align="center">
                                    <xsl:for-each select="Procent_Zgodności">
                                        <xsl:for-each select="Kw4">
                                            <xsl:apply-templates />
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td align="left">
                                    <span style="font-weight:bold; ">Liczba świadczeń</span>
                                </td>
                                <td colspan="4">                                	
                                <xsl:choose>
                							<xsl:when test="count(Świadczenia/Świadczenie )>0">
													<xsl:value-of select="count(Świadczenia/Świadczenie )" />                							
                							</xsl:when>
                							<xsl:otherwise>
												 <xsl:attribute name="style">background-color: red</xsl:attribute>  
												Brak świadczeń
										    </xsl:otherwise>										    
								</xsl:choose>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <br />
                    <br />
                    <span style="font-family:Times New Roman; font-size:larger; font-weight:bold; ">II. Świadczenia sprawozdawcze</span>
                    <br />
                    <br />
                    <xsl:for-each select="Świadczenia">
                        <table border="1" cellpadding="2" cellspacing="0" width="100%">
                            <thead>
                                <tr align="center">
                                    <td align="center" rowspan="2" valign="middle">
                                        <span style="font-weight:bold; ">Nr </span>
                                        <span style="font-weight:bold; ">sprawozda</span>
                                        <span style="font-family:Times New Roman; font-weight:bold; ">wczy</span>
                                    </td>
                                    <td align="center" rowspan="2">
                                        <span style="font-family:Times New Roman; font-weight:bold; ">Kod świad</span>
                                    </td>
                                    <td align="center" rowspan="2">
                                        <span style="font-family:Times New Roman; font-weight:bold; ">Data pier. św.</span>
                                    </td>
                                    <td align="center" rowspan="2">
                                        <span style="font-family:Times New Roman; font-weight:bold; ">Czy dotyczy rodz.</span>
                                    </td>
                                    <td align="center" colspan="3">
                                        <span style="font-weight:bold; ">Liczba</span>
                                        <span style="font-weight:bold; "></span>
                                    </td>
                                    <td align="center" colspan="3">
                                        <span style="font-weight:bold; ">Wartość</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center">
                                        <span style="font-weight:bold; ">Mies 1</span>
                                    </td>
                                    <td align="center">
                                        <span style="font-weight:bold; ">Mies 2</span>
                                    </td>
                                    <td align="center">
                                        <span style="font-weight:bold; ">Mies 3</span>
                                    </td>
                                    <td align="center">
                                        <span style="font-weight:bold; ">Mies 1</span>
                                    </td>
                                    <td align="center">
                                        <span style="font-weight:bold; ">Mies 2</span>
                                    </td>
                                    <td align="center">
                                        <span style="font-weight:bold; ">Mi</span>
                                        <span style="font-weight:bold; ">e</span>
                                        <span style="font-weight:bold; ">s 3</span>
                                    </td>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="Świadczenie">
                                    <tr align="center">
                                        <td valign="middle">
                                            <xsl:for-each select="Nr_Spr">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:choose>
                                                <xsl:when test="contains(Kod_Świad , 'Brak')">
									    		<xsl:attribute name="style">background-color: red</xsl:attribute>  									    												    											    		
                						    	</xsl:when>                						    	
                								</xsl:choose>                         
                								<xsl:value-of select="Kod_Świad"/>									    		
                                        </td>
                                        <td>
                                            <xsl:for-each select="Data_Pier_Św">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Czy_Dla_Rodz">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Liczba">
                                                <xsl:for-each select="Mies_1">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Liczba">
                                                <xsl:for-each select="Mies_2">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Liczba">
                                                <xsl:for-each select="Mies_3">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Wartość">
                                                <xsl:for-each select="Mies_1">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Wartość">
                                                <xsl:for-each select="Mies_2">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="Wartość">
                                                <xsl:for-each select="Mies_3">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                    </xsl:for-each>
                    <br />
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
